/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.test.benchmark;

import java.math.BigDecimal;
import java.util.Date;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.springside.modules.test.benchmark.BenchmarkTask;

public abstract class ConcurrentBenchmark {
    public static final String THREAD_COUNT_NAME = "thread.count";
    public static final String TOTAL_COUNT_NAME = "total.count";
    public final int threadCount;
    public final long loopCount;
    public final long totalCount;
    public CountDownLatch startLock;
    public CountDownLatch finishLock;
    public int intervalSeconds = 10;
    public Date startTime;
    private AtomicLong count = new AtomicLong(0L);
    private long totalInvokedCount = 0L;
    private ScheduledExecutorService reportExecutor;

    public ConcurrentBenchmark(int defaultThreadCount, long defaultTotalCount) {
        this.threadCount = Integer.parseInt(System.getProperty(THREAD_COUNT_NAME, String.valueOf(defaultThreadCount)));
        this.totalCount = Long.parseLong(System.getProperty(TOTAL_COUNT_NAME, String.valueOf(defaultTotalCount)));
        this.loopCount = this.totalCount / (long)this.threadCount;
        this.startLock = new CountDownLatch(this.threadCount);
        this.finishLock = new CountDownLatch(this.threadCount);
        this.reportExecutor = Executors.newSingleThreadScheduledExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        this.setUp();
        ExecutorService threadPool = Executors.newFixedThreadPool(this.threadCount);
        try {
            int i = 0;
            while (i < this.threadCount) {
                BenchmarkTask task = this.createTask();
                task.taskSequence = i++;
                task.parent = this;
                threadPool.execute(task);
            }
            this.startLock.await();
            this.startReporter();
            this.startTime = new Date();
            this.printStartMessage();
            this.finishLock.await();
            this.printFinishMessage();
        }
        finally {
            threadPool.shutdownNow();
            this.reportExecutor.shutdownNow();
            this.tearDown();
        }
    }

    private void startReporter() {
        this.reportExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    ConcurrentBenchmark.this.printProgressMessage();
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        }, this.intervalSeconds, this.intervalSeconds, TimeUnit.SECONDS);
    }

    protected void printProgressMessage() {
        long currentCount = this.count.getAndSet(0L);
        this.totalInvokedCount += currentCount;
        long currentTps = currentCount / (long)this.intervalSeconds;
        long totalTimeMillis = System.currentTimeMillis() - this.startTime.getTime();
        long totalTps = this.totalInvokedCount * 1000L / totalTimeMillis;
        System.out.printf("Current perior is %,d , tps is %,d, Total is %,d , tps is %,d.%n", currentCount, currentTps, this.totalInvokedCount, totalTps);
    }

    protected void printStartMessage() {
        String className = this.getClass().getSimpleName();
        System.out.printf("%s started at %s.%n%d threads with %,d loops, totally %,d requests will be invoked.%n", className, this.startTime.toString(), this.threadCount, this.loopCount, this.totalCount);
    }

    protected void printFinishMessage() {
        Date endTime = new Date();
        String className = this.getClass().getSimpleName();
        long totalTimeMillis = endTime.getTime() - this.startTime.getTime();
        long totalTps = this.totalCount * 1000L / totalTimeMillis;
        BigDecimal totalLatency = new BigDecimal(totalTimeMillis * (long)this.threadCount).divide(new BigDecimal(this.totalCount), 2, 4);
        System.out.printf("%s finished at %s.%n%d threads processed %,d requests after %,d ms, total tps/latency is %,d/%sms.%n", className, endTime.toString(), this.threadCount, this.totalCount, totalTimeMillis, totalTps, totalLatency.toString());
    }

    protected void incCounter() {
        this.count.incrementAndGet();
    }

    protected void setIntervalSeconds(int intervalSeconds) {
        this.intervalSeconds = intervalSeconds;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    protected abstract BenchmarkTask createTask();
}

