/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.test.cache.memcached;

import com.thimbleware.jmemcached.Cache;
import com.thimbleware.jmemcached.CacheImpl;
import com.thimbleware.jmemcached.LocalCacheElement;
import com.thimbleware.jmemcached.MemCacheDaemon;
import com.thimbleware.jmemcached.storage.CacheStorage;
import com.thimbleware.jmemcached.storage.hash.ConcurrentLinkedHashMap;
import java.net.InetSocketAddress;
import net.spy.memcached.AddrUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class MemcachedSimulator
implements InitializingBean,
DisposableBean {
    private static Logger logger = LoggerFactory.getLogger(MemcachedSimulator.class);
    private MemCacheDaemon<LocalCacheElement> jmemcached;
    private String serverUrl = "localhost:11211";
    private int maxItems = 102400;
    private long maxBytes = 0xC800000L;

    public void afterPropertiesSet() throws Exception {
        logger.info("Initializing JMemcached Server");
        this.jmemcached = new MemCacheDaemon();
        ConcurrentLinkedHashMap storage = ConcurrentLinkedHashMap.create((ConcurrentLinkedHashMap.EvictionPolicy)ConcurrentLinkedHashMap.EvictionPolicy.FIFO, (int)this.maxItems, (long)this.maxBytes);
        this.jmemcached.setCache((Cache)new CacheImpl((CacheStorage)storage));
        this.jmemcached.setAddr((InetSocketAddress)AddrUtil.getAddresses((String)this.serverUrl).get(0));
        this.jmemcached.start();
        logger.info("Initialized JMemcached Server");
    }

    public void destroy() throws Exception {
        logger.info("Shutdowning Jmemcached Server");
        this.jmemcached.stop();
        logger.info("Shutdowned Jmemcached Server");
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public void setMaxItems(int maxItems) {
        this.maxItems = maxItems;
    }

    public void setMaxBytes(long maxBytes) {
        this.maxBytes = maxBytes;
    }
}

