/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.metrics;

import java.util.concurrent.atomic.AtomicLong;
import org.springside.modules.metrics.CounterMetric;
import org.springside.modules.metrics.utils.Clock;

public class Counter {
    public static Clock clock = Clock.DEFAULT;
    public CounterMetric snapshot;
    private AtomicLong counter;
    private long totalCount;
    private long startTime;
    private long lastReportTime;

    public Counter() {
        this.reset();
    }

    public void inc() {
        this.counter.incrementAndGet();
    }

    public void inc(long n) {
        this.counter.addAndGet(n);
    }

    public void dec() {
        this.counter.decrementAndGet();
    }

    public void dec(long n) {
        this.counter.addAndGet(-n);
    }

    public CounterMetric calculateMetric() {
        long lastCount = this.counter.getAndSet(0L);
        long currentTime = clock.getCurrentTime();
        CounterMetric metric = new CounterMetric();
        this.totalCount += lastCount;
        long totalElapsed = currentTime - this.startTime;
        metric.meanRate = this.totalCount * 1000L / totalElapsed;
        metric.lastCount = lastCount;
        metric.totalCount = this.totalCount;
        long elapsed = currentTime - this.lastReportTime;
        if (elapsed > 0L) {
            metric.lastRate = lastCount * 1000L / elapsed;
        }
        this.lastReportTime = currentTime;
        this.snapshot = metric;
        return metric;
    }

    public void reset() {
        this.snapshot = new CounterMetric();
        this.counter = new AtomicLong(0L);
        this.totalCount = 0L;
        this.startTime = clock.getCurrentTime();
        this.lastReportTime = 0L;
    }

    public String toString() {
        return "Counter [counter=" + this.counter + ", totalCount=" + this.totalCount + ", startTime=" + this.startTime + ", lastReportTime=" + this.lastReportTime + "]";
    }
}

