/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.metrics;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.springside.modules.metrics.HistogramMetric;

public class Histogram {
    public HistogramMetric snapshot = new HistogramMetric();
    private List<Long> measurements = new LinkedList<Long>();
    private Double[] pcts;
    private Object lock = new Object();

    public Histogram(Double ... pcts) {
        this.pcts = pcts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(long value) {
        Object object = this.lock;
        synchronized (object) {
            this.measurements.add(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HistogramMetric calculateMetric() {
        List<Long> snapshotList = null;
        Object object = this.lock;
        synchronized (object) {
            snapshotList = this.measurements;
            this.measurements = new LinkedList<Long>();
        }
        if (snapshotList.isEmpty()) {
            return this.createEmptyMetric();
        }
        Collections.sort(snapshotList);
        int count = snapshotList.size();
        HistogramMetric metric = new HistogramMetric();
        metric.min = snapshotList.get(0);
        metric.max = snapshotList.get(count - 1);
        double sum = 0.0;
        Double[] doubleArray = snapshotList.iterator();
        while (doubleArray.hasNext()) {
            long value = doubleArray.next();
            sum += (double)value;
        }
        metric.mean = sum / (double)count;
        for (Double pct : this.pcts) {
            metric.pcts.put(pct, this.getPercent(snapshotList, count, pct));
        }
        this.snapshot = metric;
        return metric;
    }

    private HistogramMetric createEmptyMetric() {
        HistogramMetric metric = new HistogramMetric();
        metric.min = 0L;
        metric.max = 0L;
        metric.mean = 0.0;
        for (Double pct : this.pcts) {
            metric.pcts.put(pct, 0L);
        }
        return metric;
    }

    private Long getPercent(List<Long> snapshotList, int count, double pct) {
        double pos = pct * (double)(count + 1) / 100.0;
        if (pos < 1.0) {
            return snapshotList.get(0);
        }
        if (pos >= (double)count) {
            return snapshotList.get(count - 1);
        }
        return snapshotList.get((int)pos - 1);
    }

    public String toString() {
        return "Histogram [measurements=" + this.measurements + ", pcts=" + Arrays.toString((Object[])this.pcts) + "]";
    }
}

