/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.metrics;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springside.modules.metrics.Counter;
import org.springside.modules.metrics.Histogram;
import org.springside.modules.metrics.Timer;
import org.springside.modules.metrics.exporter.MetricRegistryListener;

public class MetricRegistry {
    public static final MetricRegistry INSTANCE = new MetricRegistry();
    private Double[] defaultPcts = new Double[]{90.0};
    private ConcurrentMap<String, Counter> counters = new ConcurrentHashMap<String, Counter>();
    private ConcurrentMap<String, Histogram> histograms = new ConcurrentHashMap<String, Histogram>();
    private ConcurrentMap<String, Timer> timers = new ConcurrentHashMap<String, Timer>();
    private List<MetricRegistryListener> listeners = new ArrayList<MetricRegistryListener>();

    public static String name(String name, String ... subNames) {
        StringBuilder builder = new StringBuilder(name);
        if (subNames != null) {
            for (String s : subNames) {
                if (s == null || s.isEmpty()) continue;
                builder.append('.').append(s);
            }
        }
        return builder.toString();
    }

    public Counter counter(String name) {
        if (this.counters.containsKey(name)) {
            return (Counter)this.counters.get(name);
        }
        Counter counter = new Counter();
        return this.register(this.counters, name, counter);
    }

    public Histogram histogram(String name) {
        return this.histogram(name, this.defaultPcts);
    }

    public Histogram histogram(String name, Double ... pcts) {
        if (this.histograms.containsKey(name)) {
            return (Histogram)this.histograms.get(name);
        }
        Histogram histogram = new Histogram(pcts);
        return this.register(this.histograms, name, histogram);
    }

    public Timer timer(String name) {
        return this.timer(name, this.defaultPcts);
    }

    public Timer timer(String name, Double ... pcts) {
        if (this.timers.containsKey(name)) {
            return (Timer)this.timers.get(name);
        }
        Timer timer = new Timer(pcts);
        return this.register(this.timers, name, timer);
    }

    public void clearAll() {
        this.counters.clear();
        this.histograms.clear();
        this.timers.clear();
    }

    private <T> T register(ConcurrentMap<String, T> metrics, String name, T newMetric) {
        T existingMetric = metrics.putIfAbsent(name, newMetric);
        if (existingMetric != null) {
            return existingMetric;
        }
        this.notifyNewMetric(name, newMetric);
        return newMetric;
    }

    private void notifyNewMetric(String name, Object newMetric) {
        for (MetricRegistryListener listener : this.listeners) {
            if (newMetric instanceof Counter) {
                listener.onCounterAdded(name, (Counter)newMetric);
            }
            if (newMetric instanceof Histogram) {
                listener.onHistogramAdded(name, (Histogram)newMetric);
            }
            if (!(newMetric instanceof Timer)) continue;
            listener.onTimerAdded(name, (Timer)newMetric);
        }
    }

    public SortedMap<String, Counter> getCounters() {
        return this.getMetrics(this.counters);
    }

    public SortedMap<String, Histogram> getHistograms() {
        return this.getMetrics(this.histograms);
    }

    public SortedMap<String, Timer> getTimers() {
        return this.getMetrics(this.timers);
    }

    private <T> SortedMap<String, T> getMetrics(Map<String, T> metrics) {
        return new TreeMap<String, T>(metrics);
    }

    public void setDefaultPcts(Double[] defaultPcts) {
        this.defaultPcts = defaultPcts;
    }

    public void addListener(MetricRegistryListener listener) {
        this.listeners.add(listener);
    }
}

