/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.metrics;

import org.springside.modules.metrics.Counter;
import org.springside.modules.metrics.Histogram;
import org.springside.modules.metrics.TimerMetric;
import org.springside.modules.metrics.utils.Clock;

public class Timer {
    public static Clock clock = Clock.DEFAULT;
    public TimerMetric snapshot = new TimerMetric();
    private Counter counter = new Counter();
    private Histogram histogram;

    public Timer(Double ... pcts) {
        this.histogram = new Histogram(pcts);
    }

    public void update(long start) {
        this.histogram.update(System.currentTimeMillis() - start);
        this.counter.inc();
    }

    public TimerContext start() {
        return new TimerContext(this, clock.getCurrentTime());
    }

    private void stopTimer(long startTime) {
        long elapsed = clock.getCurrentTime() - startTime;
        this.histogram.update(elapsed);
        this.counter.inc();
    }

    public TimerMetric calculateMetric() {
        TimerMetric metric = new TimerMetric();
        metric.counterMetric = this.counter.calculateMetric();
        metric.histogramMetric = this.histogram.calculateMetric();
        this.snapshot = metric;
        return metric;
    }

    public String toString() {
        return "Timer [counter=" + this.counter + ", histogram=" + this.histogram + "]";
    }

    public static class TimerContext {
        private final Timer timer;
        private final long startTime;

        private TimerContext(Timer timer, long startTime) {
            this.timer = timer;
            this.startTime = startTime;
        }

        public void stop() {
            this.timer.stopTimer(this.startTime);
        }
    }
}

