/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.metrics.exporter;

import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springside.modules.metrics.Counter;
import org.springside.modules.metrics.Histogram;
import org.springside.modules.metrics.MetricRegistry;
import org.springside.modules.metrics.Timer;
import org.springside.modules.metrics.exporter.MetricRegistryListener;

public class JmxExporter
implements MetricRegistryListener {
    private static Logger logger = LoggerFactory.getLogger(JmxExporter.class);
    private MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
    private MetricRegistry registry;
    private String domain;
    private final Map<ObjectName, ObjectName> registered;

    public JmxExporter(String domain, MetricRegistry registry) {
        this.registry = registry;
        this.domain = domain;
        this.registered = new ConcurrentHashMap<ObjectName, ObjectName>();
        registry.addListener(this);
        this.initMBeans();
    }

    private void initMBeans() {
        SortedMap<String, Counter> counters = this.registry.getCounters();
        for (Map.Entry entry : counters.entrySet()) {
            this.onCounterAdded((String)entry.getKey(), (Counter)entry.getValue());
        }
        SortedMap<String, Histogram> histograms = this.registry.getHistograms();
        for (Map.Entry entry : histograms.entrySet()) {
            this.onHistogramAdded((String)entry.getKey(), (Histogram)entry.getValue());
        }
        SortedMap<String, Timer> sortedMap = this.registry.getTimers();
        for (Map.Entry entry : sortedMap.entrySet()) {
            this.onTimerAdded((String)entry.getKey(), (Timer)entry.getValue());
        }
    }

    private void registerMBean(Object mBean, ObjectName objectName) throws InstanceAlreadyExistsException, JMException {
        ObjectInstance objectInstance = this.mBeanServer.registerMBean(mBean, objectName);
        if (objectInstance != null) {
            this.registered.put(objectName, objectInstance.getObjectName());
        } else {
            this.registered.put(objectName, objectName);
        }
    }

    private void unregisterMBean(ObjectName originalObjectName) throws InstanceNotFoundException, MBeanRegistrationException {
        ObjectName storedObjectName = this.registered.remove(originalObjectName);
        if (storedObjectName != null) {
            this.mBeanServer.unregisterMBean(storedObjectName);
        } else {
            this.mBeanServer.unregisterMBean(originalObjectName);
        }
    }

    private ObjectName createName(String type, String name) {
        try {
            return new ObjectName(this.domain, "name", name);
        }
        catch (MalformedObjectNameException e) {
            try {
                return new ObjectName(this.domain, "name", ObjectName.quote(name));
            }
            catch (MalformedObjectNameException e1) {
                logger.warn("Unable to register {} {}", new Object[]{type, name, e1});
                throw new RuntimeException(e1);
            }
        }
    }

    @Override
    public void onCounterAdded(String name, Counter counter) {
        try {
            ObjectName objectName = this.createName("counters", name);
            this.registerMBean(new JmxCounter(counter, objectName), objectName);
        }
        catch (InstanceAlreadyExistsException e) {
            logger.debug("Unable to register counter", (Throwable)e);
        }
        catch (JMException e) {
            logger.warn("Unable to register counter", (Throwable)e);
        }
    }

    @Override
    public void onHistogramAdded(String name, Histogram histogram) {
        try {
            ObjectName objectName = this.createName("histograms", name);
            this.registerMBean(new JmxHistogram(histogram, objectName), objectName);
        }
        catch (InstanceAlreadyExistsException e) {
            logger.debug("Unable to register counter", (Throwable)e);
        }
        catch (JMException e) {
            logger.warn("Unable to register counter", (Throwable)e);
        }
    }

    @Override
    public void onTimerAdded(String name, Timer timer) {
        try {
            ObjectName objectName = this.createName("timers", name);
            this.registerMBean(new JmxTimer(timer, objectName), objectName);
        }
        catch (InstanceAlreadyExistsException e) {
            logger.debug("Unable to register counter", (Throwable)e);
        }
        catch (JMException e) {
            logger.warn("Unable to register counter", (Throwable)e);
        }
    }

    private static class JmxTimer
    extends AbstractBean
    implements JmxTimerMBean {
        private final Timer metric;

        private JmxTimer(Timer metric, ObjectName objectName) {
            super(objectName);
            this.metric = metric;
        }

        @Override
        public long getLastCount() {
            return this.metric.snapshot.counterMetric.lastCount;
        }

        @Override
        public double getLastRate() {
            return this.metric.snapshot.counterMetric.lastRate;
        }

        @Override
        public long getTotalCount() {
            return this.metric.snapshot.counterMetric.totalCount;
        }

        @Override
        public double getTotalRate() {
            return this.metric.snapshot.counterMetric.meanRate;
        }

        @Override
        public long getMin() {
            return this.metric.snapshot.histogramMetric.min;
        }

        @Override
        public long getMax() {
            return this.metric.snapshot.histogramMetric.max;
        }

        @Override
        public double getMean() {
            return this.metric.snapshot.histogramMetric.mean;
        }
    }

    private static class JmxHistogram
    extends AbstractBean
    implements JmxHistogramMBean {
        private final Histogram metric;

        private JmxHistogram(Histogram metric, ObjectName objectName) {
            super(objectName);
            this.metric = metric;
        }

        @Override
        public long getMin() {
            return this.metric.snapshot.min;
        }

        @Override
        public long getMax() {
            return this.metric.snapshot.max;
        }

        @Override
        public double getMean() {
            return this.metric.snapshot.mean;
        }
    }

    private static class JmxCounter
    extends AbstractBean
    implements JmxCounterMBean {
        private final Counter metric;

        private JmxCounter(Counter metric, ObjectName objectName) {
            super(objectName);
            this.metric = metric;
        }

        @Override
        public long getLastCount() {
            return this.metric.snapshot.lastCount;
        }

        @Override
        public double getLastRate() {
            return this.metric.snapshot.lastRate;
        }

        @Override
        public long getTotalCount() {
            return this.metric.snapshot.totalCount;
        }

        @Override
        public double getTotalRate() {
            return this.metric.snapshot.meanRate;
        }
    }

    private static abstract class AbstractBean
    implements MetricMBean {
        private final ObjectName objectName;

        AbstractBean(ObjectName objectName) {
            this.objectName = objectName;
        }

        @Override
        public ObjectName objectName() {
            return this.objectName;
        }
    }

    public static interface JmxTimerMBean
    extends MetricMBean {
        public long getLastCount();

        public double getLastRate();

        public long getTotalCount();

        public double getTotalRate();

        public long getMin();

        public long getMax();

        public double getMean();
    }

    public static interface JmxHistogramMBean
    extends MetricMBean {
        public long getMin();

        public long getMax();

        public double getMean();
    }

    public static interface JmxCounterMBean
    extends MetricMBean {
        public long getLastCount();

        public double getLastRate();

        public long getTotalCount();

        public double getTotalRate();
    }

    public static interface MetricMBean {
        public ObjectName objectName();
    }
}

