/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.metrics.reporter;

import java.io.PrintStream;
import java.util.Date;
import java.util.Map;
import org.springside.modules.metrics.Counter;
import org.springside.modules.metrics.CounterMetric;
import org.springside.modules.metrics.Histogram;
import org.springside.modules.metrics.HistogramMetric;
import org.springside.modules.metrics.Timer;
import org.springside.modules.metrics.TimerMetric;
import org.springside.modules.metrics.reporter.Reporter;

public class ConsoleReporter
implements Reporter {
    private static final int CONSOLE_WIDTH = 80;
    private PrintStream output = System.out;

    @Override
    public void report(Map<String, Counter> counters, Map<String, Histogram> histograms, Map<String, Timer> timers) {
        this.printWithBanner(new Date().toString(), '=');
        this.output.println();
        if (!counters.isEmpty()) {
            this.printWithBanner("-- Counters", '-');
            for (Map.Entry<String, Object> entry : counters.entrySet()) {
                this.output.println(entry.getKey());
                this.printCounter(((Counter)entry.getValue()).snapshot);
            }
            this.output.println();
        }
        if (!histograms.isEmpty()) {
            this.printWithBanner("-- Histograms", '-');
            for (Map.Entry<String, Object> entry : histograms.entrySet()) {
                this.output.println(entry.getKey());
                this.printHistogram(((Histogram)entry.getValue()).snapshot);
            }
            this.output.println();
        }
        if (!timers.isEmpty()) {
            this.printWithBanner("-- Timers", '-');
            for (Map.Entry<String, Object> entry : timers.entrySet()) {
                this.output.println(entry.getKey());
                this.printTimer(((Timer)entry.getValue()).snapshot);
            }
            this.output.println();
        }
    }

    private void printWithBanner(String s, char c) {
        this.output.print(s);
        this.output.print(' ');
        for (int i = 0; i < 80 - s.length() - 1; ++i) {
            this.output.print(c);
        }
        this.output.println();
    }

    private void printCounter(CounterMetric counter) {
        this.output.printf("        last count = %d%n", counter.lastCount);
        this.output.printf("       total count = %d%n", counter.totalCount);
        this.output.printf("         last rate = %2.2f/s%n", counter.lastRate);
        this.output.printf("         mean rate = %2.2f/s%n", counter.meanRate);
    }

    private void printHistogram(HistogramMetric histogram) {
        this.output.printf("               min = %d%n", histogram.min);
        this.output.printf("               max = %d%n", histogram.max);
        this.output.printf("              mean = %2.2f%n", histogram.mean);
        for (Map.Entry<Double, Long> pct : histogram.pcts.entrySet()) {
            this.output.printf("           %2.2f%% <= %d %n", pct.getKey(), pct.getValue());
        }
    }

    private void printTimer(TimerMetric timer) {
        this.output.printf("             count = %d%n", timer.counterMetric.totalCount);
        this.output.printf("         last rate = %2.2f/s%n", timer.counterMetric.lastRate);
        this.output.printf("         mean rate = %2.2f/s%n", timer.counterMetric.meanRate);
        this.output.printf("               min = %d ms%n", timer.histogramMetric.min);
        this.output.printf("               max = %d ms%n", timer.histogramMetric.max);
        this.output.printf("              mean = %2.2f ms%n", timer.histogramMetric.mean);
        for (Map.Entry<Double, Long> pct : timer.histogramMetric.pcts.entrySet()) {
            this.output.printf("           %2.2f%% <= %d ms%n", pct.getKey(), pct.getValue());
        }
    }
}

