/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.metrics.reporter;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.net.SocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springside.modules.metrics.Counter;
import org.springside.modules.metrics.CounterMetric;
import org.springside.modules.metrics.Histogram;
import org.springside.modules.metrics.HistogramMetric;
import org.springside.modules.metrics.MetricRegistry;
import org.springside.modules.metrics.Timer;
import org.springside.modules.metrics.TimerMetric;
import org.springside.modules.metrics.reporter.Reporter;

public class GraphiteReporter
implements Reporter {
    private static final Pattern WHITESPACE = Pattern.compile("[\\s]+");
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static Logger logger = LoggerFactory.getLogger(GraphiteReporter.class);
    private String prefix;
    private InetSocketAddress address;
    private SocketFactory socketFactory;
    private Socket socket;
    private Writer writer;
    private GraphiteConnStatus graphiteConnStatus = GraphiteConnStatus.CONN_OK;

    public GraphiteReporter(InetSocketAddress address) {
        this(address, "metrics");
    }

    public GraphiteReporter(InetSocketAddress address, String prefix) {
        this.prefix = prefix;
        this.address = address;
        this.socketFactory = SocketFactory.getDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void report(Map<String, Counter> counters, Map<String, Histogram> histograms, Map<String, Timer> timers) {
        try {
            this.connect();
            long timestamp = System.currentTimeMillis() / 1000L;
            for (Map.Entry<String, Counter> entry : counters.entrySet()) {
                this.reportCounter(entry.getKey(), entry.getValue().snapshot, timestamp);
            }
            for (Map.Entry<String, Object> entry : histograms.entrySet()) {
                this.reportHistogram(entry.getKey(), ((Histogram)entry.getValue()).snapshot, timestamp);
            }
            for (Map.Entry<String, Object> entry : timers.entrySet()) {
                this.reportTimer(entry.getKey(), ((Timer)entry.getValue()).snapshot, timestamp);
            }
            this.flush();
            this.onConnSuccess();
        }
        catch (IOException e) {
            this.onConnFail(e);
        }
        finally {
            try {
                this.close();
            }
            catch (IOException e) {
                logger.warn("Error disconnecting from Graphite", (Throwable)e);
            }
        }
    }

    private void reportCounter(String name, CounterMetric counter, long timestamp) throws IOException {
        this.send(MetricRegistry.name(this.prefix, name, "count"), this.format(counter.lastCount), timestamp);
    }

    private void reportHistogram(String name, HistogramMetric histogram, long timestamp) throws IOException {
        this.send(MetricRegistry.name(this.prefix, name, "min"), this.format(histogram.min), timestamp);
        this.send(MetricRegistry.name(this.prefix, name, "max"), this.format(histogram.max), timestamp);
        this.send(MetricRegistry.name(this.prefix, name, "mean"), this.format(histogram.mean), timestamp);
        for (Map.Entry<Double, Long> pct : histogram.pcts.entrySet()) {
            this.send(MetricRegistry.name(this.prefix, name, this.format(pct.getKey()).replace('.', '_')), this.format(pct.getValue()), timestamp);
        }
    }

    private void reportTimer(String name, TimerMetric timer, long timestamp) throws IOException {
        this.send(MetricRegistry.name(this.prefix, name, "count"), this.format(timer.counterMetric.lastCount), timestamp);
        this.send(MetricRegistry.name(this.prefix, name, "min"), this.format(timer.histogramMetric.min), timestamp);
        this.send(MetricRegistry.name(this.prefix, name, "max"), this.format(timer.histogramMetric.max), timestamp);
        this.send(MetricRegistry.name(this.prefix, name, "mean"), this.format(timer.histogramMetric.mean), timestamp);
        for (Map.Entry<Double, Long> pct : timer.histogramMetric.pcts.entrySet()) {
            this.send(MetricRegistry.name(this.prefix, name, this.format(pct.getKey()).replace('.', '_')), this.format(pct.getValue()), timestamp);
        }
    }

    private void connect() throws IllegalStateException, IOException {
        if (this.socket != null) {
            throw new IllegalStateException("Already connected");
        }
        this.socket = this.socketFactory.createSocket(this.address.getAddress(), this.address.getPort());
        this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), UTF_8));
    }

    private void send(String name, String value, long timestamp) throws IOException {
        this.writer.write(this.sanitize(name));
        this.writer.write(32);
        this.writer.write(this.sanitize(value));
        this.writer.write(32);
        this.writer.write(this.format(timestamp));
        this.writer.write(10);
    }

    private void flush() throws IOException {
        this.writer.flush();
    }

    private void close() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
        if (this.socket != null) {
            this.socket.close();
        }
        this.socket = null;
        this.writer = null;
    }

    private String format(long n) {
        return Long.toString(n);
    }

    private String format(double v) {
        return String.format(Locale.US, "%2.2f", v);
    }

    private String sanitize(String s) {
        return WHITESPACE.matcher(s).replaceAll("-");
    }

    private void onConnFail(Exception exception) {
        if (this.graphiteConnStatus != GraphiteConnStatus.CONN_NOK) {
            logger.warn("Unable to report to Graphite", (Throwable)exception);
            this.graphiteConnStatus = GraphiteConnStatus.CONN_NOK;
        }
    }

    private void onConnSuccess() {
        if (this.graphiteConnStatus != GraphiteConnStatus.CONN_OK) {
            logger.info("Graphite connection is recovered.");
            this.graphiteConnStatus = GraphiteConnStatus.CONN_OK;
        }
    }

    private static enum GraphiteConnStatus {
        CONN_OK,
        CONN_NOK;

    }
}

