/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.metrics.reporter;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springside.modules.metrics.Counter;
import org.springside.modules.metrics.Histogram;
import org.springside.modules.metrics.MetricRegistry;
import org.springside.modules.metrics.Timer;
import org.springside.modules.metrics.reporter.Reporter;

public class ReportScheduler {
    private static final String SCHEDULER_NAME = "metrics-reporter";
    private static Logger logger = LoggerFactory.getLogger(ReportScheduler.class);
    private MetricRegistry metricRegistry;
    private List<Reporter> reporters;
    private ScheduledExecutorService executor;

    public ReportScheduler(MetricRegistry metricRegistry, Reporter ... reporters) {
        this(metricRegistry, new ArrayList<Reporter>());
        for (Reporter reporter : reporters) {
            this.addReporter(reporter);
        }
    }

    public ReportScheduler(MetricRegistry metricRegistry, List<Reporter> reporters) {
        this.metricRegistry = metricRegistry;
        this.reporters = reporters;
        this.executor = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory(SCHEDULER_NAME));
    }

    public void addReporter(Reporter reporter) {
        this.reporters.add(reporter);
    }

    public void removeReporter(Reporter reporter) {
        this.reporters.remove(reporter);
    }

    public void start(long period, TimeUnit unit) {
        this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    ReportScheduler.this.report();
                }
                catch (Throwable e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }, period, period, unit);
        logger.info("metric reporters started.");
    }

    public void stop() {
        this.executor.shutdownNow();
        try {
            if (this.executor.awaitTermination(2L, TimeUnit.SECONDS)) {
                logger.info("metric reporters stopped.");
            } else {
                logger.info("metric reporters can't stop in 2 seconds, force stopped.");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void report() {
        SortedMap<String, Counter> counterMap = this.metricRegistry.getCounters();
        SortedMap<String, Histogram> histogramMap = this.metricRegistry.getHistograms();
        SortedMap<String, Timer> timerMap = this.metricRegistry.getTimers();
        for (Counter counter : counterMap.values()) {
            counter.calculateMetric();
        }
        for (Histogram histogram : histogramMap.values()) {
            histogram.calculateMetric();
        }
        for (Timer timer : timerMap.values()) {
            timer.calculateMetric();
        }
        for (Reporter reporter : this.reporters) {
            reporter.report(counterMap, histogramMap, timerMap);
        }
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        private NamedThreadFactory(String name) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = name;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            t.setDaemon(true);
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

