/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.metrics.reporter;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springside.modules.metrics.Counter;
import org.springside.modules.metrics.CounterMetric;
import org.springside.modules.metrics.Histogram;
import org.springside.modules.metrics.HistogramMetric;
import org.springside.modules.metrics.Timer;
import org.springside.modules.metrics.TimerMetric;
import org.springside.modules.metrics.reporter.Reporter;

public class Slf4jReporter
implements Reporter {
    private Logger reportLogger;

    public Slf4jReporter() {
        this("metrics");
    }

    public Slf4jReporter(String loggerName) {
        this.reportLogger = LoggerFactory.getLogger((String)loggerName);
    }

    @Override
    public void report(Map<String, Counter> counters, Map<String, Histogram> histograms, Map<String, Timer> timers) {
        for (Map.Entry<String, Counter> entry : counters.entrySet()) {
            this.logCounter(entry.getKey(), entry.getValue().snapshot);
        }
        for (Map.Entry<String, Object> entry : histograms.entrySet()) {
            this.logHistogram(entry.getKey(), ((Histogram)entry.getValue()).snapshot);
        }
        for (Map.Entry<String, Object> entry : timers.entrySet()) {
            this.logTimer(entry.getKey(), ((Timer)entry.getValue()).snapshot);
        }
    }

    private void logCounter(String name, CounterMetric counter) {
        this.reportLogger.info("type=COUNTER, name={}, count={}, lastRate={}, meanRate={}", new Object[]{name, counter.totalCount, counter.lastRate, counter.meanRate});
    }

    private void logHistogram(String name, HistogramMetric histogram) {
        this.reportLogger.info("type=HISTOGRAM, name={}, min={}, max={}, mean={}{}", new Object[]{name, histogram.min, histogram.max, histogram.mean, this.buildPcts(histogram.pcts)});
    }

    private void logTimer(String name, TimerMetric timer) {
        this.reportLogger.info("type=TIMER, name={}, count={}, lastRate={}, meanRate={}, min={}ms, max={}ms, mean={}ms", new Object[]{name, timer.counterMetric.totalCount, timer.counterMetric.lastRate, timer.counterMetric.meanRate, timer.histogramMetric.min, timer.histogramMetric.max, timer.histogramMetric.mean, this.buildPcts(timer.histogramMetric.pcts)});
    }

    private String buildPcts(Map<Double, Long> pcts) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Double, Long> entry : pcts.entrySet()) {
            builder.append(", ").append(entry.getKey()).append("%<=").append(entry.getValue()).append("ms");
        }
        return builder.toString();
    }
}

