/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.metrics.utils;

public interface Clock {
    public static final Clock DEFAULT = new DefaultClock();

    public long getCurrentTime();

    public static class MockClock
    implements Clock {
        private long time;

        public MockClock() {
            this(0L);
        }

        public MockClock(long time) {
            this.time = time;
        }

        @Override
        public long getCurrentTime() {
            return this.time;
        }

        public void update(long newTime) {
            this.time = newTime;
        }

        public void increaseTime(int millis) {
            this.time += (long)millis;
        }

        public void decreaseTime(int millis) {
            this.time -= (long)millis;
        }
    }

    public static class DefaultClock
    implements Clock {
        @Override
        public long getCurrentTime() {
            return System.currentTimeMillis();
        }
    }
}

