/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.nosql.redis;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springside.modules.nosql.redis.JedisUtils;
import org.springside.modules.nosql.redis.pool.JedisPool;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.exceptions.JedisException;

public class JedisTemplate {
    private static Logger logger = LoggerFactory.getLogger(JedisTemplate.class);
    private JedisPool jedisPool;

    public JedisTemplate(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    public <T> T execute(JedisAction<T> jedisAction) throws JedisException {
        Jedis jedis = null;
        boolean broken = false;
        try {
            jedis = (Jedis)this.jedisPool.getResource();
            T t = jedisAction.action(jedis);
            return t;
        }
        catch (JedisException e) {
            broken = this.handleJedisException(e);
            throw e;
        }
        finally {
            this.closeResource(jedis, broken);
        }
    }

    public void execute(JedisActionNoResult jedisAction) throws JedisException {
        Jedis jedis = null;
        boolean broken = false;
        try {
            jedis = (Jedis)this.jedisPool.getResource();
            jedisAction.action(jedis);
        }
        catch (JedisException e) {
            broken = this.handleJedisException(e);
            throw e;
        }
        finally {
            this.closeResource(jedis, broken);
        }
    }

    public List<Object> execute(PipelineAction pipelineAction) throws JedisException {
        Jedis jedis = null;
        boolean broken = false;
        try {
            jedis = (Jedis)this.jedisPool.getResource();
            Pipeline pipeline = jedis.pipelined();
            pipelineAction.action(pipeline);
            List list = pipeline.syncAndReturnAll();
            return list;
        }
        catch (JedisException e) {
            broken = this.handleJedisException(e);
            throw e;
        }
        finally {
            this.closeResource(jedis, broken);
        }
    }

    public void execute(PipelineActionNoResult pipelineAction) throws JedisException {
        Jedis jedis = null;
        boolean broken = false;
        try {
            jedis = (Jedis)this.jedisPool.getResource();
            Pipeline pipeline = jedis.pipelined();
            pipelineAction.action(pipeline);
            pipeline.sync();
        }
        catch (JedisException e) {
            broken = this.handleJedisException(e);
            throw e;
        }
        finally {
            this.closeResource(jedis, broken);
        }
    }

    public JedisPool getJedisPool() {
        return this.jedisPool;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean handleJedisException(JedisException jedisException) {
        if (jedisException instanceof JedisConnectionException) {
            logger.error("Redis connection " + this.jedisPool.getAddress() + " lost.", (Throwable)jedisException);
            return true;
        } else if (jedisException instanceof JedisDataException) {
            if (jedisException.getMessage() == null || jedisException.getMessage().indexOf("READONLY") == -1) return false;
            logger.error("Redis connection " + this.jedisPool.getAddress() + " are read-only slave.", (Throwable)jedisException);
            return true;
        } else {
            logger.error("Jedis exception happen.", (Throwable)jedisException);
        }
        return true;
    }

    protected void closeResource(Jedis jedis, boolean conectionBroken) {
        try {
            if (conectionBroken) {
                this.jedisPool.returnBrokenResource(jedis);
            } else {
                this.jedisPool.returnResource(jedis);
            }
        }
        catch (Exception e) {
            logger.error("return back jedis failed, will fore close the jedis.", (Throwable)e);
            JedisUtils.destroyJedis(jedis);
        }
    }

    public Boolean del(final String ... keys) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                return jedis.del(keys) == (long)keys.length;
            }
        });
    }

    public void flushDB() {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                jedis.flushDB();
            }
        });
    }

    public String get(final String key) {
        return this.execute(new JedisAction<String>(){

            @Override
            public String action(Jedis jedis) {
                return jedis.get(key);
            }
        });
    }

    public Long getAsLong(String key) {
        String result = this.get(key);
        return result != null ? Long.valueOf(result) : null;
    }

    public Integer getAsInt(String key) {
        String result = this.get(key);
        return result != null ? Integer.valueOf(result) : null;
    }

    public List<String> mget(final String ... keys) {
        return this.execute(new JedisAction<List<String>>(){

            @Override
            public List<String> action(Jedis jedis) {
                return jedis.mget(keys);
            }
        });
    }

    public void set(final String key, final String value) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                jedis.set(key, value);
            }
        });
    }

    public void setex(final String key, final String value, final int seconds) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                jedis.setex(key, seconds, value);
            }
        });
    }

    public Boolean setnx(final String key, final String value) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                return jedis.setnx(key, value) == 1L;
            }
        });
    }

    public Boolean setnxex(final String key, final String value, final int seconds) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                String result = jedis.set(key, value, "NX", "EX", seconds);
                return JedisUtils.isStatusOk(result);
            }
        });
    }

    public String getSet(final String key, final String value) {
        return this.execute(new JedisAction<String>(){

            @Override
            public String action(Jedis jedis) {
                return jedis.getSet(key, value);
            }
        });
    }

    public Long incr(final String key) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.incr(key);
            }
        });
    }

    public Long incrBy(final String key, final long increment) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.incrBy(key, increment);
            }
        });
    }

    public Double incrByFloat(final String key, final double increment) {
        return this.execute(new JedisAction<Double>(){

            @Override
            public Double action(Jedis jedis) {
                return jedis.incrByFloat(key, increment);
            }
        });
    }

    public Long decr(final String key) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.decr(key);
            }
        });
    }

    public Long decrBy(final String key, final long decrement) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.decrBy(key, decrement);
            }
        });
    }

    public String hget(final String key, final String fieldName) {
        return this.execute(new JedisAction<String>(){

            @Override
            public String action(Jedis jedis) {
                return jedis.hget(key, fieldName);
            }
        });
    }

    public List<String> hmget(final String key, final String ... fieldsNames) {
        return this.execute(new JedisAction<List<String>>(){

            @Override
            public List<String> action(Jedis jedis) {
                return jedis.hmget(key, fieldsNames);
            }
        });
    }

    public Map<String, String> hgetAll(final String key) {
        return this.execute(new JedisAction<Map<String, String>>(){

            @Override
            public Map<String, String> action(Jedis jedis) {
                return jedis.hgetAll(key);
            }
        });
    }

    public void hset(final String key, final String fieldName, final String value) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                jedis.hset(key, fieldName, value);
            }
        });
    }

    public void hmset(final String key, final Map<String, String> map) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                jedis.hmset(key, map);
            }
        });
    }

    public Boolean hsetnx(final String key, final String fieldName, final String value) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                return jedis.hsetnx(key, fieldName, value) == 1L;
            }
        });
    }

    public Long hincrBy(final String key, final String fieldName, final long increment) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.hincrBy(key, fieldName, increment);
            }
        });
    }

    public Double hincrByFloat(final String key, final String fieldName, final double increment) {
        return this.execute(new JedisAction<Double>(){

            @Override
            public Double action(Jedis jedis) {
                return jedis.hincrByFloat(key, fieldName, increment);
            }
        });
    }

    public Long hdel(final String key, final String ... fieldsNames) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.hdel(key, fieldsNames);
            }
        });
    }

    public Boolean hexists(final String key, final String fieldName) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                return jedis.hexists(key, fieldName);
            }
        });
    }

    public Set<String> hkeys(final String key) {
        return this.execute(new JedisAction<Set<String>>(){

            @Override
            public Set<String> action(Jedis jedis) {
                return jedis.hkeys(key);
            }
        });
    }

    public Long hlen(final String key) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.hlen(key);
            }
        });
    }

    public Long lpush(final String key, final String ... values) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.lpush(key, values);
            }
        });
    }

    public String rpop(final String key) {
        return this.execute(new JedisAction<String>(){

            @Override
            public String action(Jedis jedis) {
                return jedis.rpop(key);
            }
        });
    }

    public String brpop(final String key) {
        return this.execute(new JedisAction<String>(){

            @Override
            public String action(Jedis jedis) {
                List nameValuePair = jedis.brpop(key);
                if (nameValuePair != null) {
                    return (String)nameValuePair.get(1);
                }
                return null;
            }
        });
    }

    public String brpop(final int timeout, final String key) {
        return this.execute(new JedisAction<String>(){

            @Override
            public String action(Jedis jedis) {
                List nameValuePair = jedis.brpop(timeout, new String[]{key});
                if (nameValuePair != null) {
                    return (String)nameValuePair.get(1);
                }
                return null;
            }
        });
    }

    public String rpoplpush(final String sourceKey, final String destinationKey) {
        return this.execute(new JedisAction<String>(){

            @Override
            public String action(Jedis jedis) {
                return jedis.rpoplpush(sourceKey, destinationKey);
            }
        });
    }

    public String brpoplpush(final String source, final String destination, final int timeout) {
        return this.execute(new JedisAction<String>(){

            @Override
            public String action(Jedis jedis) {
                return jedis.brpoplpush(source, destination, timeout);
            }
        });
    }

    public Long llen(final String key) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.llen(key);
            }
        });
    }

    public String lindex(final String key, final long index) {
        return this.execute(new JedisAction<String>(){

            @Override
            public String action(Jedis jedis) {
                return jedis.lindex(key, index);
            }
        });
    }

    public List<String> lrange(final String key, final int start, final int end) {
        return this.execute(new JedisAction<List<String>>(){

            @Override
            public List<String> action(Jedis jedis) {
                return jedis.lrange(key, (long)start, (long)end);
            }
        });
    }

    public void ltrim(final String key, final int start, final int end) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                jedis.ltrim(key, (long)start, (long)end);
            }
        });
    }

    public void ltrimFromLeft(final String key, final int size) {
        this.execute(new JedisActionNoResult(){

            @Override
            public void action(Jedis jedis) {
                jedis.ltrim(key, 0L, (long)(size - 1));
            }
        });
    }

    public Boolean lremFirst(final String key, final String value) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                Long count = jedis.lrem(key, 1L, value);
                return count == 1L;
            }
        });
    }

    public Boolean lremAll(final String key, final String value) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                Long count = jedis.lrem(key, 0L, value);
                return count > 0L;
            }
        });
    }

    public Boolean sadd(final String key, final String member) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                return jedis.sadd(key, new String[]{member}) == 1L;
            }
        });
    }

    public Set<String> smembers(final String key) {
        return this.execute(new JedisAction<Set<String>>(){

            @Override
            public Set<String> action(Jedis jedis) {
                return jedis.smembers(key);
            }
        });
    }

    public Boolean zadd(final String key, final double score, final String member) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                return jedis.zadd(key, score, member) == 1L;
            }
        });
    }

    public Double zscore(final String key, final String member) {
        return this.execute(new JedisAction<Double>(){

            @Override
            public Double action(Jedis jedis) {
                return jedis.zscore(key, member);
            }
        });
    }

    public Long zrank(final String key, final String member) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.zrank(key, member);
            }
        });
    }

    public Long zrevrank(final String key, final String member) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.zrevrank(key, member);
            }
        });
    }

    public Long zcount(final String key, final double min, final double max) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.zcount(key, min, max);
            }
        });
    }

    public Set<String> zrange(final String key, final int start, final int end) {
        return this.execute(new JedisAction<Set<String>>(){

            @Override
            public Set<String> action(Jedis jedis) {
                return jedis.zrange(key, (long)start, (long)end);
            }
        });
    }

    public Set<Tuple> zrangeWithScores(final String key, final int start, final int end) {
        return this.execute(new JedisAction<Set<Tuple>>(){

            @Override
            public Set<Tuple> action(Jedis jedis) {
                return jedis.zrangeWithScores(key, (long)start, (long)end);
            }
        });
    }

    public Set<String> zrevrange(final String key, final int start, final int end) {
        return this.execute(new JedisAction<Set<String>>(){

            @Override
            public Set<String> action(Jedis jedis) {
                return jedis.zrevrange(key, (long)start, (long)end);
            }
        });
    }

    public Set<Tuple> zrevrangeWithScores(final String key, final int start, final int end) {
        return this.execute(new JedisAction<Set<Tuple>>(){

            @Override
            public Set<Tuple> action(Jedis jedis) {
                return jedis.zrevrangeWithScores(key, (long)start, (long)end);
            }
        });
    }

    public Set<String> zrangeByScore(final String key, final double min, final double max) {
        return this.execute(new JedisAction<Set<String>>(){

            @Override
            public Set<String> action(Jedis jedis) {
                return jedis.zrangeByScore(key, min, max);
            }
        });
    }

    public Set<Tuple> zrangeByScoreWithScores(final String key, final double min, final double max) {
        return this.execute(new JedisAction<Set<Tuple>>(){

            @Override
            public Set<Tuple> action(Jedis jedis) {
                return jedis.zrangeByScoreWithScores(key, min, max);
            }
        });
    }

    public Set<String> zrevrangeByScore(final String key, final double max, final double min) {
        return this.execute(new JedisAction<Set<String>>(){

            @Override
            public Set<String> action(Jedis jedis) {
                return jedis.zrevrangeByScore(key, max, min);
            }
        });
    }

    public Set<Tuple> zrevrangeByScoreWithScores(final String key, final double max, final double min) {
        return this.execute(new JedisAction<Set<Tuple>>(){

            @Override
            public Set<Tuple> action(Jedis jedis) {
                return jedis.zrevrangeByScoreWithScores(key, max, min);
            }
        });
    }

    public Boolean zrem(final String key, final String member) {
        return this.execute(new JedisAction<Boolean>(){

            @Override
            public Boolean action(Jedis jedis) {
                return jedis.zrem(key, new String[]{member}) == 1L;
            }
        });
    }

    public Long zremByScore(final String key, final double start, final double end) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.zremrangeByScore(key, start, end);
            }
        });
    }

    public Long zremByRank(final String key, final long start, final long end) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.zremrangeByRank(key, start, end);
            }
        });
    }

    public Long zcard(final String key) {
        return this.execute(new JedisAction<Long>(){

            @Override
            public Long action(Jedis jedis) {
                return jedis.zcard(key);
            }
        });
    }

    public static interface PipelineActionNoResult {
        public void action(Pipeline var1);
    }

    public static interface PipelineAction {
        public List<Object> action(Pipeline var1);
    }

    public static interface JedisActionNoResult {
        public void action(Jedis var1);
    }

    public static interface JedisAction<T> {
        public T action(Jedis var1);
    }
}

