/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.nosql.redis;

import org.springside.modules.nosql.redis.JedisTemplate;
import org.springside.modules.nosql.redis.pool.JedisPool;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.JedisException;

public class JedisUtils {
    private static final String OK_CODE = "OK";
    private static final String OK_MULTI_CODE = "+OK";

    public static boolean isStatusOk(String status) {
        return status != null && (OK_CODE.equals(status) || OK_MULTI_CODE.equals(status));
    }

    public static void destroyJedis(Jedis jedis) {
        if (jedis != null && jedis.isConnected()) {
            try {
                try {
                    jedis.quit();
                }
                catch (Exception e) {
                    // empty catch block
                }
                jedis.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean ping(JedisPool pool) {
        JedisTemplate template = new JedisTemplate(pool);
        try {
            String result = template.execute(new JedisTemplate.JedisAction<String>(){

                @Override
                public String action(Jedis jedis) {
                    return jedis.ping();
                }
            });
            return result != null && result.equals("PONG");
        }
        catch (JedisException e) {
            return false;
        }
    }
}

