/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.nosql.redis.service.scheduler;

import org.springside.modules.nosql.redis.JedisTemplate;
import org.springside.modules.nosql.redis.pool.JedisPool;
import org.springside.modules.nosql.redis.service.scheduler.Keys;

public class JobStatistics {
    private JedisTemplate jedisTemplate;
    private String scheduledJobKey;
    private String readyJobKey;
    private String lockJobKey;
    private String dispatchCounterKey;
    private String retryCounterKey;

    public JobStatistics(String jobName, JedisPool jedisPool) {
        this.scheduledJobKey = Keys.getScheduledJobKey(jobName);
        this.readyJobKey = Keys.getReadyJobKey(jobName);
        this.lockJobKey = Keys.getLockJobKey(jobName);
        this.dispatchCounterKey = Keys.getDispatchCounterKey(jobName);
        this.retryCounterKey = Keys.getRetryCounterKey(jobName);
        this.jedisTemplate = new JedisTemplate(jedisPool);
    }

    public long getScheduledJobNumber() {
        return this.jedisTemplate.zcard(this.scheduledJobKey);
    }

    public long getReadyJobNumber() {
        return this.jedisTemplate.llen(this.readyJobKey);
    }

    public long getLockJobNumber() {
        return this.jedisTemplate.zcard(this.lockJobKey);
    }

    public long getDispatchCounter() {
        return this.jedisTemplate.getAsLong(this.dispatchCounterKey);
    }

    public long getRetryCounter() {
        return this.jedisTemplate.getAsLong(this.retryCounterKey);
    }

    public void restCounters() {
        this.jedisTemplate.set(this.dispatchCounterKey, "0");
        this.jedisTemplate.set(this.retryCounterKey, "0");
    }
}

