/*
 * Decompiled with CFR 0.152.
 */
package tachyon;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.recipes.leader.LeaderSelector;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListener;
import org.apache.curator.framework.recipes.leader.Participant;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.log4j.Logger;
import tachyon.Constants;

public class LeaderSelectorClient
implements Closeable,
LeaderSelectorListener {
    private final Logger LOG = Logger.getLogger((String)Constants.LOGGER_TYPE);
    private final String ZOOKEEPER_ADDRESS;
    private final String ELECTION_PATH;
    private final String LEADER_FOLDER;
    private final String NAME;
    private final LeaderSelector LEADER_SELECTOR;
    private AtomicBoolean mIsLeader = new AtomicBoolean(false);
    private volatile Thread mCurrentMasterThread = null;

    public LeaderSelectorClient(String zookeeperAddress, String electionPath, String leaderPath, String name) {
        this.ZOOKEEPER_ADDRESS = zookeeperAddress;
        this.ELECTION_PATH = electionPath;
        this.LEADER_FOLDER = leaderPath.endsWith("/") ? leaderPath : leaderPath + "/";
        this.NAME = name;
        CuratorFramework client = CuratorFrameworkFactory.newClient((String)this.ZOOKEEPER_ADDRESS, (RetryPolicy)new ExponentialBackoffRetry(1000, 3));
        client.start();
        this.LEADER_SELECTOR = new LeaderSelector(client, this.ELECTION_PATH, (LeaderSelectorListener)this);
        this.LEADER_SELECTOR.setId(name);
        this.LEADER_SELECTOR.autoRequeue();
    }

    public void start() throws IOException {
        this.LEADER_SELECTOR.start();
    }

    public boolean isLeader() {
        return this.mIsLeader.get();
    }

    public String getName() {
        return this.NAME;
    }

    public List<String> getParticipants() {
        try {
            ArrayList participants = new ArrayList(this.LEADER_SELECTOR.getParticipants());
            ArrayList<String> results = new ArrayList<String>();
            for (Participant part : participants) {
                results.add(part.getId());
            }
            return results;
        }
        catch (Exception e) {
            this.LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.mCurrentMasterThread != null) {
            this.mCurrentMasterThread.interrupt();
        }
        this.LEADER_SELECTOR.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takeLeadership(CuratorFramework client) throws Exception {
        this.mIsLeader.set(true);
        if (client.checkExists().forPath(this.LEADER_FOLDER + this.NAME) != null) {
            client.delete().forPath(this.LEADER_FOLDER + this.NAME);
        }
        client.create().creatingParentsIfNeeded().forPath(this.LEADER_FOLDER + this.NAME);
        this.LOG.info((Object)(this.NAME + " is now the leader."));
        try {
            try {
                while (true) {
                    Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
                }
            }
            catch (InterruptedException e) {
                this.LOG.error((Object)(this.NAME + " was interrupted."), (Throwable)e);
                Thread.currentThread().interrupt();
                this.mCurrentMasterThread = null;
                this.LOG.warn((Object)(this.NAME + " relinquishing leadership."));
            }
        }
        catch (Throwable throwable) {
            this.mCurrentMasterThread = null;
            this.LOG.warn((Object)(this.NAME + " relinquishing leadership."));
            throw throwable;
        }
        this.LOG.info((Object)("The current leader is " + this.LEADER_SELECTOR.getLeader().getId()));
        this.LOG.info((Object)("All partitations: " + this.LEADER_SELECTOR.getParticipants()));
        client.delete().forPath(this.LEADER_FOLDER + this.NAME);
    }

    public void stateChanged(CuratorFramework client, ConnectionState newState) {
        this.mIsLeader.set(false);
        if (newState == ConnectionState.LOST || newState == ConnectionState.SUSPENDED) {
            if (this.mCurrentMasterThread != null) {
                this.mCurrentMasterThread.interrupt();
            }
        } else {
            try {
                this.LOG.info((Object)("The current leader is " + this.LEADER_SELECTOR.getLeader().getId()));
            }
            catch (Exception e) {
                this.LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void setCurrentMasterThread(Thread currentMasterThread) {
        this.mCurrentMasterThread = currentMasterThread;
    }
}

