/*
 * Decompiled with CFR 0.152.
 */
package tachyon.conf;

import java.io.File;
import org.apache.log4j.Logger;
import tachyon.conf.Utils;

public class CommonConf
extends Utils {
    private static final Logger LOG = Logger.getLogger((String)"");
    private static CommonConf COMMON_CONF = null;
    public final String TACHYON_HOME;
    public final String UNDERFS_ADDRESS;
    public final String UNDERFS_DATA_FOLDER;
    public final String UNDERFS_WORKERS_FOLDER;
    public final String UNDERFS_HDFS_IMPL;
    public final String WEB_RESOURCES;
    public final boolean USE_ZOOKEEPER;
    public final String ZOOKEEPER_ADDRESS;
    public final String ZOOKEEPER_ELECTION_PATH;
    public final String ZOOKEEPER_LEADER_PATH;
    public final boolean ASYNC_ENABLED;

    private CommonConf() {
        if (System.getProperty("tachyon.home") == null) {
            LOG.warn((Object)"tachyon.home is not set. Using /mnt/tachyon_default_home as the default value.");
            File file = new File("/mnt/tachyon_default_home");
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        this.TACHYON_HOME = CommonConf.getProperty("tachyon.home", "/mnt/tachyon_default_home");
        this.WEB_RESOURCES = CommonConf.getProperty("tachyon.web.resources", this.TACHYON_HOME + "/src/main/java/tachyon/web/resources");
        this.UNDERFS_ADDRESS = CommonConf.getProperty("tachyon.underfs.address", this.TACHYON_HOME + "/underfs");
        this.UNDERFS_DATA_FOLDER = CommonConf.getProperty("tachyon.data.folder", this.UNDERFS_ADDRESS + "/tachyon/data");
        this.UNDERFS_WORKERS_FOLDER = CommonConf.getProperty("tachyon.workers.folder", this.UNDERFS_ADDRESS + "/tachyon/workers");
        this.UNDERFS_HDFS_IMPL = CommonConf.getProperty("tachyon.underfs.hdfs.impl", "org.apache.hadoop.hdfs.DistributedFileSystem");
        this.USE_ZOOKEEPER = CommonConf.getBooleanProperty("tachyon.usezookeeper", false);
        if (this.USE_ZOOKEEPER) {
            this.ZOOKEEPER_ADDRESS = CommonConf.getProperty("tachyon.zookeeper.address");
            this.ZOOKEEPER_ELECTION_PATH = CommonConf.getProperty("tachyon.zookeeper.election.path", "/election");
            this.ZOOKEEPER_LEADER_PATH = CommonConf.getProperty("tachyon.zookeeper.leader.path", "/leader");
        } else {
            this.ZOOKEEPER_ADDRESS = null;
            this.ZOOKEEPER_ELECTION_PATH = null;
            this.ZOOKEEPER_LEADER_PATH = null;
        }
        this.ASYNC_ENABLED = CommonConf.getBooleanProperty("tachyon.async.enabled", false);
    }

    public static synchronized CommonConf get() {
        if (COMMON_CONF == null) {
            COMMON_CONF = new CommonConf();
        }
        return COMMON_CONF;
    }

    public static synchronized void clear() {
        COMMON_CONF = null;
    }
}

