/*
 * Decompiled with CFR 0.152.
 */
package tachyon.master;

import java.io.IOException;
import tachyon.UnderFileSystem;
import tachyon.master.EditLog;
import tachyon.master.Image;
import tachyon.master.MasterInfo;

public class Journal {
    private EditLog mEditLog = new EditLog(null, true, 0L);
    private int mCurrentLogFileNum = 0;
    private String mImagePath;
    private String mStandbyImagePath = "";
    private String mEditLogPath;

    public Journal(String folder, String imageFileName, String editLogFileName) throws IOException {
        if (!folder.endsWith("/")) {
            folder = folder + "/";
        }
        this.mImagePath = folder + imageFileName;
        this.mEditLogPath = folder + editLogFileName;
    }

    public long getImageModTime() throws IOException {
        UnderFileSystem ufs = UnderFileSystem.get(this.mImagePath);
        if (!ufs.exists(this.mImagePath)) {
            return -1L;
        }
        return ufs.getModificationTimeMs(this.mImagePath);
    }

    public void loadImage(MasterInfo info) throws IOException {
        Image.load(info, this.mImagePath);
    }

    public long loadEditLog(MasterInfo info) throws IOException {
        return EditLog.load(info, this.mEditLogPath, this.mCurrentLogFileNum);
    }

    public void loadSingleLogFile(MasterInfo info, String path) throws IOException {
        EditLog.loadSingleLog(info, path);
        ++this.mCurrentLogFileNum;
    }

    public void createImage(MasterInfo info) throws IOException {
        if (this.mStandbyImagePath == "") {
            Image.create(info, this.mImagePath);
            EditLog.markUpToDate(this.mEditLogPath);
        } else {
            Image.rename(this.mStandbyImagePath, this.mImagePath);
        }
    }

    public void createImage(MasterInfo info, String imagePath) throws IOException {
        Image.create(info, imagePath);
        this.mStandbyImagePath = imagePath;
    }

    public void createEditLog(long transactionId) throws IOException {
        this.mEditLog = new EditLog(this.mEditLogPath, false, transactionId);
    }

    public EditLog getEditLog() {
        return this.mEditLog;
    }

    public void close() {
        if (this.mEditLog != null) {
            this.mEditLog.close();
        }
    }

    public void setMaxLogSize(int size) {
        this.mEditLog.setMaxLogSize(size);
    }
}

