/*
 * Decompiled with CFR 0.152.
 */
package tachyon.org.apache.thrift.server;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.org.apache.thrift.TException;
import tachyon.org.apache.thrift.TProcessor;
import tachyon.org.apache.thrift.protocol.TProtocol;
import tachyon.org.apache.thrift.server.ServerContext;
import tachyon.org.apache.thrift.server.TServer;
import tachyon.org.apache.thrift.server.TServerEventHandler;
import tachyon.org.apache.thrift.transport.TServerTransport;
import tachyon.org.apache.thrift.transport.TTransport;
import tachyon.org.apache.thrift.transport.TTransportException;

public class TThreadPoolServer
extends TServer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)TThreadPoolServer.class.getName());
    private ExecutorService executorService_;
    private volatile boolean stopped_;
    private final TimeUnit stopTimeoutUnit;
    private final long stopTimeoutVal;

    public TThreadPoolServer(Args args) {
        super(args);
        this.stopTimeoutUnit = args.stopTimeoutUnit;
        this.stopTimeoutVal = args.stopTimeoutVal;
        this.executorService_ = args.executorService != null ? args.executorService : TThreadPoolServer.createDefaultExecutorService(args);
    }

    private static ExecutorService createDefaultExecutorService(Args args) {
        SynchronousQueue<Runnable> executorQueue = new SynchronousQueue<Runnable>();
        return new ThreadPoolExecutor(args.minWorkerThreads, args.maxWorkerThreads, 60L, TimeUnit.SECONDS, executorQueue);
    }

    public void serve() {
        long newnow;
        try {
            this.serverTransport_.listen();
        }
        catch (TTransportException ttx) {
            LOGGER.error("Error occurred during listening.", (Throwable)ttx);
            return;
        }
        if (this.eventHandler_ != null) {
            this.eventHandler_.preServe();
        }
        this.stopped_ = false;
        this.setServing(true);
        while (!this.stopped_) {
            int failureCount = 0;
            try {
                TTransport client = this.serverTransport_.accept();
                WorkerProcess wp = new WorkerProcess(client);
                this.executorService_.execute(wp);
            }
            catch (TTransportException ttx) {
                if (this.stopped_) continue;
                ++failureCount;
                LOGGER.warn("Transport error occurred during acceptance of message.", (Throwable)ttx);
            }
        }
        this.executorService_.shutdown();
        long now = System.currentTimeMillis();
        for (long timeoutMS = this.stopTimeoutUnit.toMillis(this.stopTimeoutVal); timeoutMS >= 0L; timeoutMS -= newnow - now) {
            try {
                this.executorService_.awaitTermination(timeoutMS, TimeUnit.MILLISECONDS);
                break;
            }
            catch (InterruptedException ix) {
                newnow = System.currentTimeMillis();
                now = newnow;
                continue;
            }
        }
        this.setServing(false);
    }

    public void stop() {
        this.stopped_ = true;
        this.serverTransport_.interrupt();
    }

    private class WorkerProcess
    implements Runnable {
        private TTransport client_;

        private WorkerProcess(TTransport client) {
            this.client_ = client;
        }

        public void run() {
            TProcessor processor = null;
            TTransport inputTransport = null;
            TTransport outputTransport = null;
            TProtocol inputProtocol = null;
            TProtocol outputProtocol = null;
            TServerEventHandler eventHandler = null;
            ServerContext connectionContext = null;
            try {
                processor = TThreadPoolServer.this.processorFactory_.getProcessor(this.client_);
                inputTransport = TThreadPoolServer.this.inputTransportFactory_.getTransport(this.client_);
                outputTransport = TThreadPoolServer.this.outputTransportFactory_.getTransport(this.client_);
                inputProtocol = TThreadPoolServer.this.inputProtocolFactory_.getProtocol(inputTransport);
                outputProtocol = TThreadPoolServer.this.outputProtocolFactory_.getProtocol(outputTransport);
                eventHandler = TThreadPoolServer.this.getEventHandler();
                if (eventHandler != null) {
                    connectionContext = eventHandler.createContext(inputProtocol, outputProtocol);
                }
                do {
                    if (eventHandler == null) continue;
                    eventHandler.processContext(connectionContext, inputTransport, outputTransport);
                } while (!TThreadPoolServer.this.stopped_ && processor.process(inputProtocol, outputProtocol));
            }
            catch (TTransportException ttx) {
            }
            catch (TException tx) {
                LOGGER.error("Thrift error occurred during processing of message.", (Throwable)tx);
            }
            catch (Exception x) {
                LOGGER.error("Error occurred during processing of message.", (Throwable)x);
            }
            if (eventHandler != null) {
                eventHandler.deleteContext(connectionContext, inputProtocol, outputProtocol);
            }
            if (inputTransport != null) {
                inputTransport.close();
            }
            if (outputTransport != null) {
                outputTransport.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Args
    extends TServer.AbstractServerArgs<Args> {
        public int minWorkerThreads = 5;
        public int maxWorkerThreads = Integer.MAX_VALUE;
        public ExecutorService executorService;
        public int stopTimeoutVal = 60;
        public TimeUnit stopTimeoutUnit = TimeUnit.SECONDS;

        public Args(TServerTransport transport) {
            super(transport);
        }

        public Args minWorkerThreads(int n) {
            this.minWorkerThreads = n;
            return this;
        }

        public Args maxWorkerThreads(int n) {
            this.maxWorkerThreads = n;
            return this;
        }

        public Args executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }
    }
}

