/*
 * Decompiled with CFR 0.152.
 */
package tachyon.worker;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.log4j.Logger;
import tachyon.Constants;
import tachyon.HeartbeatThread;
import tachyon.conf.UserConf;
import tachyon.org.apache.thrift.TException;
import tachyon.org.apache.thrift.protocol.TBinaryProtocol;
import tachyon.org.apache.thrift.protocol.TProtocol;
import tachyon.org.apache.thrift.transport.TFramedTransport;
import tachyon.org.apache.thrift.transport.TSocket;
import tachyon.org.apache.thrift.transport.TTransportException;
import tachyon.thrift.BlockInfoException;
import tachyon.thrift.FailedToCheckpointException;
import tachyon.thrift.FileDoesNotExistException;
import tachyon.thrift.SuspectedFileSizeException;
import tachyon.thrift.TachyonException;
import tachyon.thrift.WorkerService;
import tachyon.worker.WorkerClientHeartbeatExecutor;

public class WorkerClient {
    private final Logger LOG = Logger.getLogger((String)Constants.LOGGER_TYPE);
    private final WorkerService.Client CLIENT;
    private TProtocol mProtocol;
    private InetSocketAddress mWorkerAddress;
    private boolean mIsConnected = false;
    private long mUserId;
    private HeartbeatThread mHeartbeatThread = null;
    private String mRootFolder = null;

    public WorkerClient(InetSocketAddress address, long userId) {
        this.mWorkerAddress = address;
        this.mProtocol = new TBinaryProtocol(new TFramedTransport(new TSocket(this.mWorkerAddress.getHostName(), this.mWorkerAddress.getPort())));
        this.CLIENT = new WorkerService.Client(this.mProtocol);
        this.mUserId = userId;
        this.mHeartbeatThread = new HeartbeatThread("WorkerClientToWorkerHeartbeat", new WorkerClientHeartbeatExecutor(this, this.mUserId), UserConf.get().HEARTBEAT_INTERVAL_MS);
        this.mHeartbeatThread.setDaemon(true);
    }

    public synchronized void accessBlock(long blockId) throws TException {
        this.CLIENT.accessBlock(blockId);
    }

    public synchronized void addCheckpoint(long userId, int fileId) throws IOException, TException {
        try {
            this.CLIENT.addCheckpoint(userId, fileId);
        }
        catch (FileDoesNotExistException e) {
            throw new IOException(e);
        }
        catch (SuspectedFileSizeException e) {
            throw new IOException(e);
        }
        catch (FailedToCheckpointException e) {
            throw new IOException(e);
        }
        catch (BlockInfoException e) {
            throw new IOException(e);
        }
    }

    public synchronized void cacheBlock(long userId, long blockId) throws IOException, TException {
        try {
            this.CLIENT.cacheBlock(userId, blockId);
        }
        catch (FileDoesNotExistException e) {
            throw new IOException(e);
        }
        catch (BlockInfoException e) {
            throw new IOException(e);
        }
        catch (SuspectedFileSizeException e) {
            throw new IOException(e);
        }
    }

    public synchronized void close() {
        if (this.mIsConnected) {
            this.mProtocol.getTransport().close();
            this.mHeartbeatThread.shutdown();
            this.mIsConnected = false;
        }
    }

    public synchronized String getUserTempFolder(long userId) throws TException {
        return this.CLIENT.getUserTempFolder(userId);
    }

    public synchronized String getUserUnderfsTempFolder(long userId) throws TException {
        return this.CLIENT.getUserUnderfsTempFolder(userId);
    }

    public synchronized String getDataFolder() throws TException {
        if (this.mRootFolder == null) {
            this.mRootFolder = this.CLIENT.getDataFolder();
        }
        return this.mRootFolder;
    }

    public synchronized boolean isConnected() {
        return this.mIsConnected;
    }

    public synchronized void lockBlock(long blockId, long userId) throws TException {
        this.CLIENT.lockBlock(blockId, userId);
    }

    public synchronized boolean open() {
        if (!this.mIsConnected) {
            try {
                this.mProtocol.getTransport().open();
            }
            catch (TTransportException e) {
                this.LOG.error((Object)e.getMessage(), (Throwable)e);
                return false;
            }
            this.mHeartbeatThread.start();
            this.mIsConnected = true;
        }
        return this.mIsConnected;
    }

    public synchronized boolean requestSpace(long userId, long requestBytes) throws TException {
        return this.CLIENT.requestSpace(userId, requestBytes);
    }

    public synchronized void returnSpace(long userId, long returnSpaceBytes) throws TException {
        this.CLIENT.returnSpace(userId, returnSpaceBytes);
    }

    public synchronized void unlockBlock(long blockId, long userId) throws TException {
        this.CLIENT.unlockBlock(blockId, userId);
    }

    public synchronized void userHeartbeat(long userId) throws TException {
        this.CLIENT.userHeartbeat(userId);
    }

    public synchronized boolean asyncCheckpoint(int fid) throws TachyonException, TException {
        return this.CLIENT.asyncCheckpoint(fid);
    }
}

