/*
 * Decompiled with CFR 0.152.
 */
package tachyon.worker;

public class WorkerSpaceCounter {
    private final long CAPACITY_BYTES;
    private long mUsedBytes;

    public WorkerSpaceCounter(long capacityBytes) {
        this.CAPACITY_BYTES = capacityBytes;
        this.mUsedBytes = 0L;
    }

    public synchronized long getAvailableBytes() {
        return this.CAPACITY_BYTES - this.mUsedBytes;
    }

    public long getCapacityBytes() {
        return this.CAPACITY_BYTES;
    }

    public synchronized long getUsedBytes() {
        return this.mUsedBytes;
    }

    public synchronized boolean requestSpaceBytes(long requestSpaceBytes) {
        if (this.getAvailableBytes() < requestSpaceBytes) {
            return false;
        }
        this.mUsedBytes += requestSpaceBytes;
        return true;
    }

    public synchronized void returnUsedBytes(long returnUsedBytes) {
        this.mUsedBytes -= returnUsedBytes;
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder("WorkerSpaceCounter(");
        sb.append(" TOTAL_BYTES: ").append(this.CAPACITY_BYTES);
        sb.append(", mUsedBytes: ").append(this.mUsedBytes);
        sb.append(", mAvailableBytes: ").append(this.CAPACITY_BYTES - this.mUsedBytes);
        sb.append(" )");
        return sb.toString();
    }

    public synchronized void updateUsedBytes(long usedBytes) {
        this.mUsedBytes = usedBytes;
    }
}

