/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.springsecurity4.dialect.processor;

import org.springframework.security.core.Authentication;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.extras.springsecurity4.auth.AuthUtils;
import org.thymeleaf.processor.attr.AbstractTextChildModifierAttrProcessor;

public class AuthenticationAttrProcessor
extends AbstractTextChildModifierAttrProcessor {
    public static final int ATTR_PRECEDENCE = 1300;
    public static final String ATTR_NAME = "authentication";

    public AuthenticationAttrProcessor() {
        super(ATTR_NAME);
    }

    public int getPrecedence() {
        return 1300;
    }

    protected String getText(Arguments arguments, Element element, String attributeName) {
        String attributeValue = element.getAttributeValue(attributeName);
        if (attributeValue == null || attributeValue.trim().equals("")) {
            return null;
        }
        Authentication authentication = AuthUtils.getAuthenticationObject();
        Object authenticationProperty = AuthUtils.getAuthenticationProperty(authentication, attributeValue);
        if (authenticationProperty == null) {
            return null;
        }
        return authenticationProperty.toString();
    }
}

