/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.tiles2.spring4.web.factory;

import java.lang.reflect.Field;
import org.apache.tiles.definition.DefinitionsFactory;
import org.apache.tiles.preparer.PreparerFactory;
import org.springframework.web.servlet.view.tiles2.TilesConfigurer;
import org.thymeleaf.exceptions.ConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TilesConfigurerSuperClassIntegration {
    static final String USE_MUTABLE_TILES_CONTAINER_PROPERTY = "useMutableTilesContainer";
    static final String DEFINITIONS_PROPERTY = "definitions";
    static final String CHECK_REFRESH_PROPERTY = "checkRefresh";
    static final String VALIDATE_DEFINITIONS_PROPERTY = "validateDefinitions";
    static final String DEFINITIONS_FACTORY_CLASS_PROPERTY = "definitionsFactoryClass";
    static final String PREPARER_FACTORY_CLASS_PROPERTY = "preparerFactoryClass";

    static Object accessSuperClassProperty(TilesConfigurer tilesConfigurer, String name) {
        try {
            Field field = TilesConfigurer.class.getDeclaredField(name);
            field.setAccessible(true);
            Object value = field.get(tilesConfigurer);
            field.setAccessible(false);
            return value;
        }
        catch (Exception e) {
            throw new ConfigurationException("Cannot access field \"" + name + "\"  in " + "class " + tilesConfigurer.getClass().getName() + ". Maybe the " + "implementation of its superclass has changed and the current " + "integration facilities are is no longer compatible.", (Throwable)e);
        }
    }

    static boolean accessSuperClassBooleanProperty(TilesConfigurer tilesConfigurer, String name) {
        Object objResult = TilesConfigurerSuperClassIntegration.accessSuperClassProperty(tilesConfigurer, name);
        if (objResult == null) {
            throw new ConfigurationException("Cannot access field \"" + name + "\"  in " + "class " + tilesConfigurer.getClass().getName() + " (returned null). Maybe the " + "implementation of its superclass has changed and the current " + "integration facilities are is no longer compatible.");
        }
        if (!(objResult instanceof Boolean)) {
            throw new ConfigurationException("Cannot access boolean field \"" + name + "\"  in " + "class " + tilesConfigurer.getClass().getName() + ". Maybe the " + "implementation of its superclass has changed and the current " + "integration facilities are is no longer compatible.");
        }
        Boolean result = (Boolean)objResult;
        return result;
    }

    static Class<?> accessSuperClassClassProperty(TilesConfigurer tilesConfigurer, String name) {
        Object objResult = TilesConfigurerSuperClassIntegration.accessSuperClassProperty(tilesConfigurer, name);
        if (objResult == null) {
            return null;
        }
        if (!(objResult instanceof Class)) {
            throw new ConfigurationException("Cannot access class-typed field \"" + name + "\"  in " + "class " + tilesConfigurer.getClass().getName() + ". Maybe the " + "implementation of its superclass has changed and the current " + "integration facilities are is no longer compatible.");
        }
        return (Class)objResult;
    }

    static String[] accessSuperClassStringArrayProperty(TilesConfigurer tilesConfigurer, String name) {
        Object objResult = TilesConfigurerSuperClassIntegration.accessSuperClassProperty(tilesConfigurer, name);
        if (objResult == null) {
            return null;
        }
        if (!(objResult instanceof String[])) {
            throw new ConfigurationException("Cannot access String[] field \"" + name + "\"  in " + "class " + tilesConfigurer.getClass().getName() + ". Maybe the " + "implementation of its superclass has changed and the current " + "integration facilities are is no longer compatible.");
        }
        return (String[])objResult;
    }

    static boolean getUseMutableTilesContainer(TilesConfigurer tilesConfigurer) {
        return TilesConfigurerSuperClassIntegration.accessSuperClassBooleanProperty(tilesConfigurer, USE_MUTABLE_TILES_CONTAINER_PROPERTY);
    }

    static boolean getCheckRefresh(TilesConfigurer tilesConfigurer) {
        return TilesConfigurerSuperClassIntegration.accessSuperClassBooleanProperty(tilesConfigurer, CHECK_REFRESH_PROPERTY);
    }

    static boolean getValidateDefinitions(TilesConfigurer tilesConfigurer) {
        return TilesConfigurerSuperClassIntegration.accessSuperClassBooleanProperty(tilesConfigurer, VALIDATE_DEFINITIONS_PROPERTY);
    }

    static Class<? extends DefinitionsFactory> getDefinitionsFactoryClass(TilesConfigurer tilesConfigurer) {
        return TilesConfigurerSuperClassIntegration.accessSuperClassClassProperty(tilesConfigurer, DEFINITIONS_FACTORY_CLASS_PROPERTY);
    }

    static Class<? extends PreparerFactory> getPreparerFactoryClass(TilesConfigurer tilesConfigurer) {
        return TilesConfigurerSuperClassIntegration.accessSuperClassClassProperty(tilesConfigurer, PREPARER_FACTORY_CLASS_PROPERTY);
    }

    static String[] getDefinitions(TilesConfigurer tilesConfigurer) {
        return TilesConfigurerSuperClassIntegration.accessSuperClassStringArrayProperty(tilesConfigurer, DEFINITIONS_PROPERTY);
    }

    private TilesConfigurerSuperClassIntegration() {
    }
}

