/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.tiles2.context;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.awareness.TilesRequestContextFactoryAware;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.context.TilesRequestContextFactory;
import org.apache.tiles.servlet.context.ExternalWriterHttpServletResponse;
import org.apache.tiles.servlet.context.ServletTilesRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.DialectAwareProcessingContext;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.extras.tiles2.renderer.FragmentMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThymeleafTilesRequestContextFactory
implements TilesRequestContextFactory,
TilesRequestContextFactoryAware {
    private static final Logger logger = LoggerFactory.getLogger(ThymeleafTilesRequestContextFactory.class);
    private TilesRequestContextFactory parent = null;

    public TilesRequestContext createRequestContext(TilesApplicationContext tilesApplicationContext, Object ... requestItems) {
        if (requestItems.length == 5 && requestItems[0] instanceof TemplateEngine && (requestItems[1] instanceof IProcessingContext || requestItems[1] instanceof IContext) && requestItems[2] instanceof HttpServletRequest && requestItems[3] instanceof HttpServletResponse && requestItems[4] instanceof Writer || requestItems.length == 6 && requestItems[0] instanceof TemplateEngine && (requestItems[1] instanceof IProcessingContext || requestItems[1] instanceof IContext) && requestItems[2] instanceof HttpServletRequest && requestItems[3] instanceof HttpServletResponse && requestItems[4] instanceof Writer && requestItems[5] instanceof FragmentMetadata) {
            ServletTilesRequestContext result;
            TemplateEngine templateEngine = (TemplateEngine)requestItems[0];
            Object contextObject = requestItems[1];
            HttpServletRequest request = (HttpServletRequest)requestItems[2];
            HttpServletResponse response = (HttpServletResponse)requestItems[3];
            Writer writer = (Writer)requestItems[4];
            FragmentMetadata fragmentMetadata = requestItems.length == 6 ? (FragmentMetadata)requestItems[5] : null;
            IProcessingContext processingContext = contextObject instanceof IProcessingContext ? (IProcessingContext)contextObject : new DialectAwareProcessingContext((IContext)contextObject, templateEngine.getConfiguration().getDialects().values());
            request.setAttribute("%%THYMELEAF_TEMPLATE_ENGINE%%", (Object)templateEngine);
            request.setAttribute("%%THYMELEAF_PROCESSING_CONTEXT%%", (Object)processingContext);
            if (fragmentMetadata != null) {
                request.setAttribute("%%THYMELEAF_FRAGMENT_METADATA%%", (Object)fragmentMetadata);
            }
            ExternalWriterHttpServletResponse responseWithWriter = new ExternalWriterHttpServletResponse(response, writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer));
            Object object = result = this.parent != null ? this.parent.createRequestContext(tilesApplicationContext, new Object[]{request, responseWithWriter}) : new ServletTilesRequestContext(tilesApplicationContext, request, (HttpServletResponse)responseWithWriter);
            if (logger.isTraceEnabled()) {
                logger.trace("[THYMELEAF][TILES] Processed Thymeleaf Tiles Request Context. Created instance of {}", new Object[]{result != null ? result.getClass().getName() : null});
            }
            return result;
        }
        return null;
    }

    @Deprecated
    public void init(Map<String, String> configurationParameters) {
    }

    public void setRequestContextFactory(TilesRequestContextFactory contextFactory) {
        this.parent = contextFactory;
    }
}

