/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.tiles2.renderer;

import java.io.IOException;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.tiles.Attribute;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.context.TilesRequestContextFactory;
import org.apache.tiles.evaluator.AttributeEvaluatorFactory;
import org.apache.tiles.renderer.impl.AbstractTypeDetectingAttributeRenderer;
import org.apache.tiles.servlet.context.ServletTilesRequestContext;
import org.apache.tiles.servlet.context.ServletUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.extras.tiles2.renderer.FragmentMetadata;
import org.thymeleaf.extras.tiles2.renderer.ThymeleafAttributeRenderer;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataCleaningAttributeRendererWrapper
extends AbstractTypeDetectingAttributeRenderer {
    private static final Logger logger = LoggerFactory.getLogger(MetadataCleaningAttributeRendererWrapper.class);
    private final AbstractTypeDetectingAttributeRenderer renderer;

    public MetadataCleaningAttributeRendererWrapper(AbstractTypeDetectingAttributeRenderer renderer) {
        Validate.notNull((Object)renderer, (String)"Wrapped renderer cannot be null");
        this.renderer = renderer;
    }

    public void render(Attribute attribute, TilesRequestContext tilesRequestContext) throws IOException {
        ServletTilesRequestContext requestContext;
        HttpServletRequest request;
        FragmentMetadata fragmentBehaviour;
        Object value = attribute.getValue();
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][TILES] Executing wrapped renderer of class {} for attribute with value \"{}\"", new Object[]{this.renderer.getClass().getName(), value});
        }
        if ((fragmentBehaviour = (FragmentMetadata)(request = (requestContext = ServletUtil.getServletRequest((TilesRequestContext)tilesRequestContext)).getRequest()).getAttribute("%%THYMELEAF_FRAGMENT_METADATA%%")) == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("[THYMELEAF][TILES] No Fragment Behaviour object has been found in request. Normal execution will be triggered for attribute with value \"{}\"", new Object[]{value});
            }
            this.renderer.render(attribute, tilesRequestContext);
        } else {
            if (!(this.renderer instanceof ThymeleafAttributeRenderer)) {
                if (logger.isTraceEnabled()) {
                    logger.trace("[THYMELEAF][TILES] A Fragment Behaviour object has been found in request, and renderer is of class {}, which is not a Thymeleaf renderer. Fragment Behaviour object will be removed from request before rendering attribute with value \"{}\"", new Object[]{this.renderer.getClass().getName(), value});
                }
                request.removeAttribute("%%THYMELEAF_FRAGMENT_METADATA%%");
            } else if (logger.isTraceEnabled()) {
                logger.trace("[THYMELEAF][TILES] A Fragment Behaviour object has been found in request, and renderer is of class {}, which is a Thymeleaf renderer. Fragment Behaviour will be used when rendering attribute with value \"{}\"", new Object[]{this.renderer.getClass().getName(), value});
            }
            this.renderer.render(attribute, tilesRequestContext);
        }
        request.removeAttribute("%%THYMELEAF_FRAGMENT_METADATA%%");
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][TILES] Finished execution of wrapped renderer of class {} for attribute with value \"{}\"", new Object[]{this.renderer.getClass().getName(), value});
        }
    }

    public void write(Object value, Attribute attribute, TilesRequestContext tilesRequestContext) throws IOException {
        this.renderer.write(value, attribute, tilesRequestContext);
    }

    public boolean isRenderable(Object value, Attribute attribute, TilesRequestContext request) {
        return this.renderer.isRenderable(value, attribute, request);
    }

    public boolean isRenderable(Attribute attribute, TilesRequestContext request) {
        return this.renderer.isRenderable(attribute, request);
    }

    public void setRequestContextFactory(TilesRequestContextFactory contextFactory) {
        this.renderer.setRequestContextFactory(contextFactory);
    }

    public void setApplicationContext(TilesApplicationContext applicationContext) {
        this.renderer.setApplicationContext(applicationContext);
    }

    public void setAttributeEvaluatorFactory(AttributeEvaluatorFactory attributeEvaluatorFactory) {
        this.renderer.setAttributeEvaluatorFactory(attributeEvaluatorFactory);
    }

    protected TilesRequestContext getRequestContext(Object ... requestItems) {
        throw new UnsupportedOperationException("Method getRequestContext() is not implemented by " + ((Object)((Object)this)).getClass().getName() + " (it is protected)");
    }

    protected boolean isPermitted(TilesRequestContext request, Set<String> roles) {
        throw new UnsupportedOperationException("Method isPermitted() is not implemented by " + ((Object)((Object)this)).getClass().getName() + " (it is protected)");
    }
}

