/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.tiles2.renderer;

import java.util.List;
import org.thymeleaf.Configuration;
import org.thymeleaf.Template;
import org.thymeleaf.TemplateProcessingParameters;
import org.thymeleaf.TemplateRepository;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.dom.Node;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.fragment.IFragmentSpec;
import org.thymeleaf.standard.fragment.StandardFragment;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TilesFragment {
    private final String templateName;
    private final IFragmentSpec fragmentSpec;

    public TilesFragment(String templateName, IFragmentSpec fragmentSpec) {
        Validate.notNull((Object)fragmentSpec, (String)"Fragment spec cannot be null or empty");
        Validate.notNull((Object)templateName, (String)"Template name cannot be null or 'this' in Tiles fragment selections");
        this.templateName = templateName;
        this.fragmentSpec = fragmentSpec;
    }

    public TilesFragment(StandardFragment standardFragment) {
        Validate.notNull((Object)standardFragment, (String)"Standard Fragment cannot be null");
        this.templateName = standardFragment.getTemplateName();
        this.fragmentSpec = standardFragment.getFragmentSpec();
        Validate.notNull((Object)this.templateName, (String)"Template name cannot be null or 'this' in Tiles fragment selections");
        if (standardFragment.getParameters() != null && standardFragment.getParameters().size() > 0) {
            throw new TemplateProcessingException("Tiles-based fragment selections cannot specify parameters. But selection for template \"" + this.templateName + "\" and fragment spec " + "\"" + this.fragmentSpec.toString() + "\" does specify some.");
        }
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public IFragmentSpec getFragmentSpec() {
        return this.fragmentSpec;
    }

    public List<Node> extractFragment(Configuration configuration, IProcessingContext context, TemplateRepository templateRepository) {
        String targetTemplateName = this.getTemplateName();
        TemplateProcessingParameters fragmentTemplateProcessingParameters = new TemplateProcessingParameters(configuration, targetTemplateName, context);
        Template parsedFragmentTemplate = templateRepository.getTemplate(fragmentTemplateProcessingParameters);
        List nodes = this.fragmentSpec.extractFragment(configuration, parsedFragmentTemplate.getDocument().getChildren());
        if (nodes == null) {
            return null;
        }
        for (Node node : nodes) {
            if (!node.hasParent()) continue;
            node.getParent().clearChildren();
        }
        return nodes;
    }
}

