/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.view;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.js.ajax.AjaxHandler;
import org.springframework.util.StringUtils;
import org.thymeleaf.Configuration;
import org.thymeleaf.dom.DOMSelector;
import org.thymeleaf.exceptions.ConfigurationException;
import org.thymeleaf.fragment.DOMSelectorFragmentSpec;
import org.thymeleaf.fragment.IFragmentSpec;
import org.thymeleaf.spring4.SpringTemplateEngine;
import org.thymeleaf.spring4.view.AjaxEnabledView;
import org.thymeleaf.spring4.view.ThymeleafView;
import org.thymeleaf.standard.fragment.StandardFragmentSignatureNodeReferenceChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxThymeleafView
extends ThymeleafView
implements AjaxEnabledView {
    private static final Logger vlogger = LoggerFactory.getLogger(AjaxThymeleafView.class);
    private static final String FRAGMENTS_PARAM = "fragments";
    private AjaxHandler ajaxHandler = null;

    @Override
    public AjaxHandler getAjaxHandler() {
        return this.ajaxHandler;
    }

    @Override
    public void setAjaxHandler(AjaxHandler ajaxHandler) {
        this.ajaxHandler = ajaxHandler;
    }

    @Override
    public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AjaxHandler templateAjaxHandler = this.getAjaxHandler();
        if (templateAjaxHandler == null) {
            throw new ConfigurationException("[THYMELEAF] AJAX Handler set into " + AjaxThymeleafView.class.getSimpleName() + " instance for template " + this.getTemplateName() + " is null.");
        }
        if (templateAjaxHandler.isAjaxRequest(request, response)) {
            String[] fragmentsToRender = this.getRenderFragments(model, request, response);
            if (fragmentsToRender.length == 0) {
                vlogger.warn("[THYMELEAF] An Ajax request was detected, but no fragments were specified to be re-rendered.  Falling back to full page render.  This can cause unpredictable results when processing the ajax response on the client.");
                super.render(model, request, response);
                return;
            }
            if (this.getTemplateEngine() == null) {
                throw new IllegalArgumentException("Property 'templateEngine' is required");
            }
            SpringTemplateEngine templateEngine = this.getTemplateEngine();
            Configuration configuration = templateEngine.getConfiguration();
            String dialectPrefix = AjaxThymeleafView.getStandardDialectPrefix(configuration);
            String fragmentSignatureAttributeName = "fragment";
            StandardFragmentSignatureNodeReferenceChecker nodeReferenceChecker = new StandardFragmentSignatureNodeReferenceChecker(configuration, dialectPrefix, "fragment");
            for (String fragmentToRender : fragmentsToRender) {
                if (fragmentToRender == null) continue;
                String fragmentSelector = fragmentToRender;
                if (fragmentSelector.length() > 3 && fragmentSelector.charAt(0) == '[' && fragmentSelector.charAt(fragmentSelector.length() - 1) == ']' && fragmentSelector.charAt(fragmentSelector.length() - 2) != '\'') {
                    fragmentSelector = fragmentSelector.substring(1, fragmentSelector.length() - 1);
                }
                DOMSelectorFragmentSpec fragmentSpec = new DOMSelectorFragmentSpec(fragmentSelector, (DOMSelector.INodeReferenceChecker)nodeReferenceChecker);
                super.renderFragment((IFragmentSpec)fragmentSpec, model, request, response);
            }
        } else {
            super.render(model, request, response);
        }
    }

    protected String[] getRenderFragments(Map model, HttpServletRequest request, HttpServletResponse response) {
        String fragmentsParam = request.getParameter(FRAGMENTS_PARAM);
        String[] renderFragments = StringUtils.commaDelimitedListToStringArray((String)fragmentsParam);
        return StringUtils.trimArrayElements((String[])renderFragments);
    }
}

