/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring5.util;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.util.StringUtils;
import org.unbescape.uri.UriEscape;

public final class SpringRequestUtils {
    public static void checkViewNameNotInRequest(String viewName, HttpServletRequest request) {
        boolean found;
        String vn = StringUtils.pack((String)viewName);
        String requestURI = StringUtils.pack((String)UriEscape.unescapeUriPath((String)request.getRequestURI()));
        boolean bl = found = requestURI != null && requestURI.contains(vn);
        if (!found) {
            Enumeration paramNames = request.getParameterNames();
            while (!found && paramNames.hasMoreElements()) {
                String[] paramValues = request.getParameterValues((String)paramNames.nextElement());
                for (int i = 0; !found && i < paramValues.length; ++i) {
                    String paramValue = StringUtils.pack((String)paramValues[i]);
                    if (!paramValue.contains(vn)) continue;
                    found = true;
                }
            }
        }
        if (found) {
            throw new TemplateProcessingException("View name is an executable expression, and it is present in a literal manner in request path or parameters, which is forbidden for security reasons.");
        }
    }

    private SpringRequestUtils() {
    }
}

