/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.tools.FeatureTreeNode;

public final class FeatureExtractionResult {
    private final Map<FeatureObjectType, FeaturesStructure> collection = new EnumMap<FeatureObjectType, FeaturesStructure>(FeatureObjectType.class);

    public void addNewFeatureTree(FeatureObjectType type, FeatureTreeNode root) {
        FeaturesStructure list = this.collection.get((Object)type);
        if (list == null) {
            list = new FeaturesStructure();
            this.collection.put(type, list);
        }
        if (list.list == null) {
            list.list = new ArrayList<FeatureTreeNode>();
        }
        list.list.add(root);
    }

    public List<FeatureTreeNode> getFeatureTreesForType(FeatureObjectType type) {
        FeaturesStructure list = this.collection.get((Object)type);
        return list == null || list.list == null ? Collections.emptyList() : list.list;
    }

    public void addNewError(FeatureObjectType type, String errorID) {
        FeaturesStructure list = this.collection.get((Object)type);
        if (list == null) {
            list = new FeaturesStructure();
            this.collection.put(type, list);
        }
        if (list.errors == null) {
            list.errors = new ArrayList<String>();
        }
        list.errors.add(errorID);
    }

    public List<String> getErrorsForType(FeatureObjectType type) {
        FeaturesStructure list = this.collection.get((Object)type);
        return list == null || list.errors == null ? Collections.emptyList() : list.errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FeatureExtractionResult)) {
            return false;
        }
        FeatureExtractionResult that = (FeatureExtractionResult)o;
        return this.collection != null ? this.collection.equals(that.collection) : that.collection == null;
    }

    public int hashCode() {
        return this.collection != null ? this.collection.hashCode() : 0;
    }

    private class FeaturesStructure {
        List<FeatureTreeNode> list = null;
        List<String> errors = null;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FeaturesStructure)) {
                return false;
            }
            FeaturesStructure that = (FeaturesStructure)o;
            if (this.list != null ? !this.list.equals(that.list) : that.list != null) {
                return false;
            }
            return this.errors != null ? this.errors.equals(that.errors) : that.errors == null;
        }

        public int hashCode() {
            int result = this.list != null ? this.list.hashCode() : 0;
            result = 31 * result + (this.errors != null ? this.errors.hashCode() : 0);
            return result;
        }
    }
}

