/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.objects;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.EmbeddedFileFeaturesData;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.objects.EmbeddedFileFeaturesObjectAdapter;
import org.verapdf.features.objects.Feature;
import org.verapdf.features.objects.FeaturesObject;
import org.verapdf.features.tools.CreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;

public class EmbeddedFileFeaturesObject
extends FeaturesObject {
    private static final Logger LOGGER = Logger.getLogger(EmbeddedFileFeaturesObject.class.getCanonicalName());
    private static final String EMBEDDED_FILE = "embeddedFile";
    private static final String FILE_NAME = "fileName";
    private static final String DESCRIPTION = "description";
    private static final String AF_RELATIONSHIP = "afRelationship";
    private static final String SUB_TYPE = "subtype";
    private static final String FILTER = "filter";
    private static final String CREATION_DATE = "creationDate";
    private static final String MOD_DATE = "modDate";
    private static final String CHECK_SUM = "checkSum";
    private static final String SIZE = "size";

    public EmbeddedFileFeaturesObject(EmbeddedFileFeaturesObjectAdapter adapter) {
        super(adapter);
    }

    @Override
    public FeatureObjectType getType() {
        return FeatureObjectType.EMBEDDED_FILE;
    }

    @Override
    public FeatureTreeNode collectFeatures() throws FeatureParsingException {
        EmbeddedFileFeaturesObjectAdapter efAdapter = (EmbeddedFileFeaturesObjectAdapter)this.adapter;
        FeatureTreeNode root = FeatureTreeNode.createRootNode(EMBEDDED_FILE);
        root.setAttribute("id", "file" + efAdapter.getIndex());
        CreateNodeHelper.addNotEmptyNode(FILE_NAME, efAdapter.getFileName(), root);
        CreateNodeHelper.addNotEmptyNode(DESCRIPTION, efAdapter.getDescription(), root);
        CreateNodeHelper.addNotEmptyNode(AF_RELATIONSHIP, efAdapter.getAFRelationship(), root);
        CreateNodeHelper.addNotEmptyNode(SUB_TYPE, efAdapter.getSubtype(), root);
        CreateNodeHelper.addNotEmptyNode(FILTER, efAdapter.getFilter(), root);
        CreateNodeHelper.createDateNode(CREATION_DATE, root, efAdapter.getCreationDate(), this);
        CreateNodeHelper.createDateNode(MOD_DATE, root, efAdapter.getModDate(), this);
        CreateNodeHelper.addNotEmptyNode(CHECK_SUM, efAdapter.getCheckSum(), root);
        Long size = efAdapter.getSize();
        if (size != null) {
            CreateNodeHelper.addNotEmptyNode(SIZE, String.valueOf(size), root);
        }
        return root;
    }

    @Override
    public FeaturesData getData() {
        EmbeddedFileFeaturesObjectAdapter efAdapter = (EmbeddedFileFeaturesObjectAdapter)this.adapter;
        InputStream efIn = efAdapter.getData();
        if (efIn == null) {
            LOGGER.log(Level.FINE, "Missed embedded file InputStream");
            return null;
        }
        EmbeddedFileFeaturesData.Builder builder = new EmbeddedFileFeaturesData.Builder(efIn);
        builder.name(efAdapter.getFileName());
        builder.description(efAdapter.getDescription());
        builder.afRelationship(efAdapter.getAFRelationship());
        builder.subtype(efAdapter.getSubtype());
        builder.creationDate(efAdapter.getCreationDate());
        builder.modDate(efAdapter.getModDate());
        builder.checkSum(efAdapter.getCheckSum());
        Long size = efAdapter.getSize();
        if (size != null) {
            builder.size(size.intValue());
        }
        return builder.build();
    }

    static List<Feature> getFeaturesList() {
        ArrayList<Feature> featuresList = new ArrayList<Feature>();
        featuresList.add(new Feature("File Name", EmbeddedFileFeaturesObject.generateVariableXPath(EMBEDDED_FILE, FILE_NAME), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Description", EmbeddedFileFeaturesObject.generateVariableXPath(EMBEDDED_FILE, DESCRIPTION), Feature.FeatureType.STRING));
        featuresList.add(new Feature("AFRelationship", EmbeddedFileFeaturesObject.generateVariableXPath(EMBEDDED_FILE, AF_RELATIONSHIP), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Subtype", EmbeddedFileFeaturesObject.generateVariableXPath(EMBEDDED_FILE, SUB_TYPE), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Filter", EmbeddedFileFeaturesObject.generateVariableXPath(EMBEDDED_FILE, FILTER), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Creation Date", EmbeddedFileFeaturesObject.generateVariableXPath(EMBEDDED_FILE, CREATION_DATE), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Modification Date", EmbeddedFileFeaturesObject.generateVariableXPath(EMBEDDED_FILE, MOD_DATE), Feature.FeatureType.STRING));
        featuresList.add(new Feature("CheckSum", EmbeddedFileFeaturesObject.generateVariableXPath(EMBEDDED_FILE, CHECK_SUM), Feature.FeatureType.STRING));
        featuresList.add(new Feature("Size", EmbeddedFileFeaturesObject.generateVariableXPath(EMBEDDED_FILE, SIZE), Feature.FeatureType.NUMBER));
        featuresList.add(new Feature("Error IDs", EmbeddedFileFeaturesObject.generateAttributeXPath(EMBEDDED_FILE, "errorId"), Feature.FeatureType.STRING));
        return featuresList;
    }
}

