/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.policy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.verapdf.core.VeraPDFException;
import org.verapdf.core.utils.FileUtils;
import org.verapdf.policy.SchematronPipeline;

public final class PolicyChecker {
    private static final TransformerFactory factory = TransformerFactory.newInstance();
    public static final String SCHEMA_EXT = "sch";
    public static final String XSL_EXT = "xsl";
    public static final String XSLT_EXT = "xslt";
    public static final List<String> allowedExtensions = Arrays.asList("sch", "xsl", "xslt");
    private static final String resourcePath = "org/verapdf/policy/";
    private static final String mergeXsl = "org/verapdf/policy/MergeMrrPolicy.xsl";
    private static final Templates cachedMergeXsl = SchematronPipeline.createCachedTransform("org/verapdf/policy/MergeMrrPolicy.xsl");

    private PolicyChecker() {
    }

    public static void insertPolicyReport(File policyReport, File mrrReport, OutputStream mergedReport) throws VeraPDFException {
        try {
            Transformer transformer = cachedMergeXsl.newTransformer();
            transformer.setParameter("policyResultPath", policyReport.getAbsolutePath());
            transformer.transform(new StreamSource(mrrReport), new StreamResult(mergedReport));
            return;
        }
        catch (TransformerException excep) {
            throw new VeraPDFException("Problem merging XML files.", excep);
        }
    }

    public static void applyPolicy(File policy, InputStream xmlReport, OutputStream policyReport) throws VeraPDFException {
        String ext = FileUtils.extFromFileName(policy.getName());
        if (!PolicyChecker.isAllowedExtension(ext)) {
            throw new VeraPDFException("Policy file extension must be one of sch, xsl, or xslt");
        }
        boolean isXsl = !ext.equalsIgnoreCase(SCHEMA_EXT);
        try (FileInputStream fis = new FileInputStream(policy);){
            PolicyChecker.applyPolicy(fis, xmlReport, policyReport, isXsl);
        }
        catch (IOException excep) {
            throw new VeraPDFException("IOException applying policy file " + policy.getAbsolutePath(), excep);
        }
    }

    public static boolean isFilenameAllowedExtension(String filename) {
        return PolicyChecker.isAllowedExtension(FileUtils.extFromFileName(filename));
    }

    public static boolean isAllowedExtension(String ext) {
        return allowedExtensions.contains(ext.toLowerCase());
    }

    public static void applyPolicy(InputStream policy, InputStream xmlReport, OutputStream policyReport, boolean isXsl) throws VeraPDFException {
        try {
            if (isXsl) {
                PolicyChecker.applySchematronXsl(policy, xmlReport, policyReport);
            } else {
                PolicyChecker.applyRawSchematron(policy, xmlReport, policyReport);
            }
        }
        catch (IOException | TransformerException excep) {
            throw new VeraPDFException("Exception when applying policy file.", excep);
        }
    }

    private static void applyRawSchematron(InputStream rawSchematron, InputStream xmlReport, OutputStream policyReport) throws TransformerException, IOException {
        File schemaXsl = PolicyChecker.createSchematronXslFile(rawSchematron);
        try (FileInputStream fis = new FileInputStream(schemaXsl);){
            PolicyChecker.applySchematronXsl(fis, xmlReport, policyReport);
        }
        if (!schemaXsl.delete()) {
            schemaXsl.deleteOnExit();
        }
    }

    private static File createSchematronXslFile(InputStream rawSchematron) throws TransformerException, IOException {
        File resXsl = File.createTempFile("veraPDF_", "SchXsl");
        try (FileOutputStream fos = new FileOutputStream(resXsl);){
            SchematronPipeline.processSchematron(rawSchematron, fos);
        }
        return resXsl;
    }

    private static void applySchematronXsl(InputStream schematronXsl, InputStream xmlReport, OutputStream policyReport) throws TransformerException {
        Transformer transformer = factory.newTransformer(new StreamSource(schematronXsl));
        transformer.transform(new StreamSource(xmlReport), new StreamResult(policyReport));
    }
}

