/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor.reports;

import javax.xml.bind.annotation.XmlRootElement;
import org.verapdf.processor.reports.AbstractBatchJobSummary;

@XmlRootElement(name="featureReports")
public final class FeaturesBatchSummary
extends AbstractBatchJobSummary {
    private static final FeaturesBatchSummary DEFAULT = new FeaturesBatchSummary();

    private FeaturesBatchSummary() {
        this(0, 0);
    }

    private FeaturesBatchSummary(int totalJobs, int failedJobs) {
        super(totalJobs, failedJobs);
    }

    @Override
    public int getFailedJobCount() {
        return this.failedJobs;
    }

    @Override
    public int getTotalJobCount() {
        return this.totalJobs;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.failedJobs;
        result = 31 * result + this.totalJobs;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractBatchJobSummary)) {
            return false;
        }
        AbstractBatchJobSummary other = (AbstractBatchJobSummary)obj;
        if (this.failedJobs != other.failedJobs) {
            return false;
        }
        return this.totalJobs == other.totalJobs;
    }

    public static FeaturesBatchSummary defaultInstance() {
        return DEFAULT;
    }

    public static FeaturesBatchSummary fromValues(int totalJobs, int failedJobs) {
        if (totalJobs < 0) {
            throw new IllegalArgumentException("Argument totalJobs must be >= 0");
        }
        if (failedJobs < 0) {
            throw new IllegalArgumentException("Argument failedJobs must be >= 0");
        }
        if (failedJobs > totalJobs) {
            throw new IllegalArgumentException("Argument failedJobs can not be > totalJobs");
        }
        return new FeaturesBatchSummary(totalJobs, failedJobs);
    }
}

