/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.as.filters.io.ASBufferedInFilter;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSInteger;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.cos.COSTrailer;
import org.verapdf.cos.xref.COSXRefEntry;
import org.verapdf.cos.xref.COSXRefInfo;

class XrefStreamParser {
    private COSXRefInfo section;
    private COSStream xrefCOSStream;

    XrefStreamParser(COSXRefInfo section, COSStream xrefCOSStream) {
        this.section = section;
        this.xrefCOSStream = xrefCOSStream;
    }

    void parseStreamAndTrailer() throws IOException {
        try (ASInputStream xrefInputStream = this.xrefCOSStream.getData(COSStream.FilterFlags.DECODE);){
            COSObject indexObject = this.initializeIndex();
            List<Long> objIDs = this.initializeObjIDs(indexObject);
            this.parseStream(xrefInputStream, objIDs);
            this.setTrailer();
        }
    }

    private COSObject initializeIndex() throws IOException {
        COSObject indexObject = this.xrefCOSStream.getKey(ASAtom.INDEX);
        if (indexObject.empty()) {
            COSObject[] defaultIndex = new COSObject[]{COSInteger.construct(0L), this.xrefCOSStream.getKey(ASAtom.SIZE)};
            indexObject = COSArray.construct(2, defaultIndex);
        } else if (indexObject.getType() != COSObjType.COS_ARRAY || indexObject.size() % 2 != 0) {
            throw new IOException("Index array in xref stream has odd amount of elements.");
        }
        return indexObject;
    }

    private List<Long> initializeObjIDs(COSObject indexObject) throws IOException {
        ArrayList<Long> objIDs = new ArrayList<Long>();
        for (int i = 0; i < indexObject.size(); i += 2) {
            Long firstID = indexObject.at(i).getInteger();
            Long lengthOfSubsection = indexObject.at(i + 1).getInteger();
            if (firstID == null || lengthOfSubsection == null) {
                throw new IOException("Failed to initialize objects ids");
            }
            int j = 0;
            while ((long)j < lengthOfSubsection) {
                objIDs.add(firstID + (long)j);
                ++j;
            }
        }
        return objIDs;
    }

    private void parseStream(ASInputStream xrefInputStream, List<Long> objIDs) throws IOException {
        byte[] buffer;
        long read;
        COSObject sizesObject = this.xrefCOSStream.getKey(ASAtom.W);
        if (sizesObject.getType() != COSObjType.COS_ARRAY || sizesObject.size() != 3) {
            throw new IOException("W array in xref shall have 3 elements.");
        }
        Long field0Size = sizesObject.at(0).getInteger();
        Long field1Size = sizesObject.at(1).getInteger();
        Long field2Size = sizesObject.at(2).getInteger();
        if (field0Size == null || field1Size == null || field2Size == null) {
            throw new IOException("Object of W array shall contain an Integer");
        }
        byte[] field0 = new byte[field0Size.intValue()];
        byte[] field1 = new byte[field1Size.intValue()];
        byte[] field2 = new byte[field2Size.intValue()];
        byte[] remainedBytes = new byte[]{};
        int objIdIndex = 0;
        block5: while ((read = (long)xrefInputStream.read(buffer = new byte[2048], 2048)) != -1L) {
            buffer = ASBufferedInFilter.concatenate(remainedBytes, remainedBytes.length, buffer, (int)read);
            int pointer = 0;
            while (objIdIndex < objIDs.size()) {
                if (pointer + field0.length + field1.length + field2.length > buffer.length) {
                    remainedBytes = Arrays.copyOfRange(buffer, pointer, buffer.length);
                    continue block5;
                }
                Long id = objIDs.get(objIdIndex);
                System.arraycopy(buffer, pointer, field0, 0, field0.length);
                System.arraycopy(buffer, pointer += field0.length, field1, 0, field1.length);
                System.arraycopy(buffer, pointer += field1.length, field2, 0, field2.length);
                pointer += field2.length;
                int type = 1;
                if (field0.length > 0) {
                    type = (int)XrefStreamParser.numberFromBytes(field0);
                }
                switch (type) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        COSXRefEntry xref = new COSXRefEntry();
                        xref.offset = XrefStreamParser.numberFromBytes(field1);
                        xref.generation = field2.length > 0 ? (int)XrefStreamParser.numberFromBytes(field2) : 0;
                        this.section.getXRefSection().add(new COSKey(id.intValue(), xref.generation), xref.offset);
                        break;
                    }
                    case 2: {
                        COSXRefEntry xref = new COSXRefEntry();
                        xref.offset = -XrefStreamParser.numberFromBytes(field1);
                        if (field2.length > 0) {
                            xref.generation = 0;
                        }
                        this.section.getXRefSection().add(new COSKey(id.intValue(), xref.generation), xref.offset);
                        break;
                    }
                    default: {
                        throw new IOException("Error in parsing xref stream");
                    }
                }
                ++objIdIndex;
            }
        }
    }

    private void setTrailer() {
        COSTrailer trailer = this.section.getTrailer();
        if (this.xrefCOSStream.getKey(ASAtom.SIZE).get() != null) {
            trailer.setSize(((COSInteger)this.xrefCOSStream.getKey(ASAtom.SIZE).get()).get());
        }
        if (this.xrefCOSStream.getKey(ASAtom.PREV).get() != null) {
            trailer.setPrev(((COSInteger)this.xrefCOSStream.getKey(ASAtom.PREV).get()).get());
        }
        if (this.xrefCOSStream.getKey(ASAtom.ROOT).get() != null) {
            trailer.setRoot(this.xrefCOSStream.getKey(ASAtom.ROOT));
        }
        if (this.xrefCOSStream.getKey(ASAtom.ENCRYPT).get() != null) {
            trailer.setEncrypt(this.xrefCOSStream.getKey(ASAtom.ENCRYPT));
        }
        if (this.xrefCOSStream.getKey(ASAtom.INFO).get() != null) {
            trailer.setInfo(this.xrefCOSStream.getKey(ASAtom.INFO));
        }
        if (this.xrefCOSStream.getKey(ASAtom.ID).get() != null) {
            trailer.setID(this.xrefCOSStream.getKey(ASAtom.ID));
        }
    }

    private static long numberFromBytes(byte[] num) {
        long res = 0L;
        for (int i = 0; i < num.length; ++i) {
            res += (long)((num[i] & 0xFF) << (num.length - i - 1) * 8);
        }
        return res;
    }
}

