/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.cmap;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSObject;
import org.verapdf.parser.Token;
import org.verapdf.parser.postscript.PSObject;
import org.verapdf.parser.postscript.PSParser;
import org.verapdf.parser.postscript.PostScriptException;
import org.verapdf.pd.font.cmap.CIDInterval;
import org.verapdf.pd.font.cmap.CMap;
import org.verapdf.pd.font.cmap.CodeSpace;
import org.verapdf.pd.font.cmap.NotDefInterval;
import org.verapdf.pd.font.cmap.PDCMap;
import org.verapdf.pd.font.cmap.SingleCIDMapping;
import org.verapdf.pd.font.cmap.ToUnicodeInterval;

public class CMapParser
extends PSParser {
    private static final Logger LOGGER = Logger.getLogger(CMapParser.class.getCanonicalName());
    private COSObject lastCOSName;
    private CMap cMap = new CMap();
    private static final String WMODE_STRING = "WMode";
    private static final String REGISTRY_SRTRING = "Registry";
    private static final String ORDERING_STRING = "Ordering";
    private static final String CMAP_NAME_STRING = "CMapName";
    private static final String SUPPLEMENT_STRING = "Supplement";
    private static final String CID_COUNT_STRING = "CIDCount";

    public CMapParser(ASInputStream fileStream) throws IOException {
        super(fileStream);
    }

    public CMap getCMap() {
        return this.cMap;
    }

    public void parse() throws IOException, PostScriptException {
        try {
            this.initializeToken();
            this.skipSpaces(true);
            while (this.getToken().type != Token.Type.TT_EOF) {
                COSObject nextObject = this.nextObject();
                this.processObject(nextObject);
            }
        }
        finally {
            this.source.close();
        }
        this.setValuesFromUserDict(this.cMap);
    }

    private void processObject(COSObject object) throws IOException, PostScriptException {
        switch (object.getType()) {
            case COS_INTEGER: {
                int listLength = (int)this.getToken().integer;
                COSObject nextObject = this.nextObject();
                if (this.getToken().type == Token.Type.TT_KEYWORD && this.processList(listLength, this.getToken().getValue())) break;
                PSObject.getPSObject(object).execute(this.operandStack, this.userDict);
                PSObject.getPSObject(nextObject).execute(this.operandStack, this.userDict);
                break;
            }
            case COS_NAME: {
                if (this.getToken().getValue().equals("usecmap")) {
                    CMap usedCMap = new PDCMap(this.lastCOSName).getCMapFile();
                    if (usedCMap != null) {
                        this.cMap.useCMap(usedCMap);
                        break;
                    }
                    this.cMap.setUsesNonPredefinedCMap(true);
                    LOGGER.log(Level.FINE, "Can't load predefined CMap with name " + this.lastCOSName);
                    break;
                }
                PSObject.getPSObject(object).execute(this.operandStack, this.userDict);
                this.lastCOSName = object;
                break;
            }
            default: {
                PSObject.getPSObject(object).execute(this.operandStack, this.userDict);
            }
        }
    }

    private boolean processList(int listLength, String type) throws IOException {
        if (!type.startsWith("begin")) {
            return false;
        }
        String key = type.substring(5);
        block18: for (int i = 0; i < listLength; ++i) {
            switch (key) {
                case "codespacerange": {
                    this.readLineCodeSpaceRange();
                    continue block18;
                }
                case "cidrange": {
                    this.readLineCIDRange();
                    continue block18;
                }
                case "notdefrange": {
                    this.readLineNotDefRange();
                    continue block18;
                }
                case "cidchar": {
                    this.readSingleCharMapping();
                    continue block18;
                }
                case "notdefchar": {
                    this.readSingleNotDefMapping();
                    continue block18;
                }
                case "bfchar": {
                    this.readSingleToUnicodeMapping();
                    continue block18;
                }
                case "bfrange": {
                    this.readLineBFRange();
                    continue block18;
                }
                default: {
                    return false;
                }
            }
        }
        this.nextToken();
        if (!this.getToken().getValue().equals("end" + key)) {
            LOGGER.log(Level.FINE, "Unexpected end of " + key + " in CMap");
        }
        return true;
    }

    private void readLineCodeSpaceRange() throws IOException {
        this.nextToken();
        this.checkTokenType(Token.Type.TT_HEXSTRING, "codespacerange list");
        byte[] begin = this.getToken().getByteValue();
        this.nextToken();
        this.checkTokenType(Token.Type.TT_HEXSTRING, "codespacerange list");
        byte[] end = this.getToken().getByteValue();
        CodeSpace codeSpace = new CodeSpace(begin, end);
        boolean overlaps = false;
        for (CodeSpace cs : this.cMap.getCodeSpaces()) {
            if (!cs.overlaps(codeSpace)) continue;
            overlaps = true;
            break;
        }
        if (!overlaps) {
            this.cMap.getCodeSpaces().add(codeSpace);
            if (begin.length < this.cMap.shortestCodeSpaceLength) {
                this.cMap.shortestCodeSpaceLength = begin.length;
            }
        } else {
            LOGGER.log(Level.FINE, "CMap " + this.cMap.getName() + " has overlapping codespace ranges.");
        }
    }

    private void readLineCIDRange() throws IOException {
        this.nextToken();
        this.checkTokenType(Token.Type.TT_HEXSTRING, "cidrange list");
        long cidRangeStart = CMapParser.numberFromBytes(this.getToken().getByteValue());
        this.nextToken();
        this.checkTokenType(Token.Type.TT_HEXSTRING, "cidrange list");
        long cidRangeEnd = CMapParser.numberFromBytes(this.getToken().getByteValue());
        this.nextToken();
        this.checkTokenType(Token.Type.TT_INTEGER, "cidrange list");
        this.cMap.addCidInterval(new CIDInterval((int)cidRangeStart, (int)cidRangeEnd, (int)this.getToken().integer));
    }

    private void readLineNotDefRange() throws IOException {
        this.nextToken();
        this.checkTokenType(Token.Type.TT_HEXSTRING, "notdef list");
        long notDefRangeStart = CMapParser.numberFromBytes(this.getToken().getByteValue());
        this.nextToken();
        this.checkTokenType(Token.Type.TT_HEXSTRING, "notdef list");
        long notDefRangeEnd = CMapParser.numberFromBytes(this.getToken().getByteValue());
        this.nextToken();
        this.checkTokenType(Token.Type.TT_INTEGER, "notdef list");
        this.cMap.addNotDefInterval(new NotDefInterval((int)notDefRangeStart, (int)notDefRangeEnd, (int)this.getToken().integer));
    }

    private void readSingleCharMapping() throws IOException {
        this.nextToken();
        this.checkTokenType(Token.Type.TT_HEXSTRING, "cidchar");
        long charCode = CMapParser.numberFromBytes(this.getToken().getByteValue());
        this.nextToken();
        this.checkTokenType(Token.Type.TT_INTEGER, "cidchar");
        this.cMap.addSingleCidMapping(new SingleCIDMapping((int)charCode, (int)this.getToken().integer));
    }

    private void readSingleNotDefMapping() throws IOException {
        this.nextToken();
        this.checkTokenType(Token.Type.TT_HEXSTRING, "notdefchar");
        long notDefCharCode = CMapParser.numberFromBytes(this.getToken().getByteValue());
        this.nextToken();
        this.checkTokenType(Token.Type.TT_INTEGER, "notdefchar");
        this.cMap.addSingleNotDefMapping(new SingleCIDMapping((int)notDefCharCode, (int)this.getToken().integer));
    }

    private void readSingleToUnicodeMapping() throws IOException {
        this.nextToken();
        this.checkTokenType(Token.Type.TT_HEXSTRING, "bfchar");
        long bfCharCode = CMapParser.numberFromBytes(this.getToken().getByteValue());
        String unicodeName = this.readStringFromUnicodeSequenceToken();
        this.cMap.addUnicodeMapping((int)bfCharCode, unicodeName);
    }

    private void readLineBFRange() throws IOException {
        this.nextToken();
        this.checkTokenType(Token.Type.TT_HEXSTRING, "bfrange");
        byte[] rangeBegin = this.getToken().getByteValue();
        long bfRangeBegin = CMapParser.numberFromBytes(rangeBegin);
        this.nextToken();
        this.checkTokenType(Token.Type.TT_HEXSTRING, "bfrange");
        long bfRangeEnd = CMapParser.getBfrangeEndFromBytes(this.getToken().getByteValue(), rangeBegin);
        this.nextToken();
        if (this.getToken().type == Token.Type.TT_OPENARRAY) {
            for (long i = bfRangeBegin; i <= bfRangeEnd; ++i) {
                this.cMap.addUnicodeMapping((int)i, this.readStringFromUnicodeSequenceToken());
            }
            this.nextToken();
        } else {
            byte[] token = this.getToken().getByteValue();
            int lastByte = token[token.length - 1] & 0xFF;
            if ((long)lastByte > 255L - bfRangeEnd + bfRangeBegin) {
                bfRangeEnd = 255L + bfRangeBegin - (long)lastByte;
            }
            this.cMap.addUnicodeInterval(new ToUnicodeInterval(bfRangeBegin, bfRangeEnd, this.getToken().getByteValue()));
        }
    }

    static long numberFromBytes(byte[] num) {
        long res = 0L;
        for (int i = 0; i < num.length; ++i) {
            res += (long)((num[i] & 0xFF) << (num.length - i - 1) * 8);
        }
        return res;
    }

    private static long getBfrangeEndFromBytes(byte[] endRange, byte[] beginRange) {
        long res = 0L;
        for (int i = 0; i < endRange.length; ++i) {
            if (i < endRange.length - 1) {
                byte endRangeByte = endRange[i];
                byte beginRangeByte = beginRange[i];
                if (endRangeByte != beginRangeByte) {
                    LOGGER.log(Level.WARNING, "Incorrect bfrange in toUnicode CMap: bfrange contains more than 256 code.");
                }
                res += (long)((beginRangeByte & 0xFF) << (endRange.length - i - 1) * 8);
                continue;
            }
            res += (long)((endRange[i] & 0xFF) << (endRange.length - i - 1) * 8);
        }
        return res;
    }

    private String readStringFromUnicodeSequenceToken() throws IOException {
        this.nextToken();
        if (this.getToken().type == Token.Type.TT_NAME) {
            return this.getToken().getValue();
        }
        if (this.getToken().type == Token.Type.TT_HEXSTRING) {
            byte[] token = this.getToken().getByteValue();
            if (token.length == 1) {
                return new String(token, StandardCharsets.ISO_8859_1);
            }
            return new String(token, StandardCharsets.UTF_16BE);
        }
        throw new IOException("CMap contains invalid entry in bfchar. Expected " + (Object)((Object)Token.Type.TT_NAME) + " or " + (Object)((Object)Token.Type.TT_HEXSTRING) + " but got " + (Object)((Object)this.getToken().type));
    }

    private void checkTokenType(Token.Type type, String where) throws IOException {
        if (this.getToken().type != type) {
            throw new IOException("CMap contains invalid entry in " + where + ". Expected " + (Object)((Object)type) + " but got " + (Object)((Object)this.getToken().type));
        }
    }

    @Override
    protected boolean isEndOfComment(byte ch) {
        return CMapParser.isCR(ch) || CMapParser.isFF(ch);
    }

    private void setValuesFromUserDict(CMap cMap) {
        cMap.setName(this.getStringFromUserDict(CMAP_NAME_STRING));
        cMap.setRegistry(this.getStringFromUserDict(REGISTRY_SRTRING));
        cMap.setOrdering(this.getStringFromUserDict(ORDERING_STRING));
        cMap.setwMode((int)this.getLongFromUserDict(WMODE_STRING));
        cMap.setSupplement((int)this.getLongFromUserDict(SUPPLEMENT_STRING));
    }

    private String getStringFromUserDict(String key) {
        COSObject string = (COSObject)this.userDict.get(ASAtom.getASAtom(key));
        return string == null ? null : string.getString();
    }

    private long getLongFromUserDict(String key) {
        COSObject number = (COSObject)this.userDict.get(ASAtom.getASAtom(key));
        if (number == null) {
            return 0L;
        }
        Long res = number.getInteger();
        return res == null ? 0L : res;
    }
}

