/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jsr303;

import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.Localizer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.ValidationErrorFeedback;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.string.interpolator.MapVariableInterpolator;
import org.apache.wicket.validation.IErrorMessageSource;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.ValidationError;
import org.wicketstuff.jsr303.JSR303Validation;
import org.wicketstuff.jsr303.ViolationErrorBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanValidator {
    private final Form<?> context;

    public BeanValidator(Form<?> contextOrNull) {
        this.context = contextOrNull;
    }

    public <U> boolean isValid(U e) {
        if (e == null) {
            return true;
        }
        JSR303Validation.getInstance();
        Set s = JSR303Validation.getValidator().validate(e, new Class[0]);
        if (s.isEmpty()) {
            return true;
        }
        for (ConstraintViolation v : s) {
            if (this.context == null) continue;
            ValidationError ve = new ViolationErrorBuilder.Bean(v).createError();
            this.context.error((Serializable)new ValidationErrorFeedback((IValidationError)ve, ve.getErrorMessage((IErrorMessageSource)new MessageSource())));
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MessageSource
    implements IErrorMessageSource {
        private final Set<String> triedKeys = new LinkedHashSet<String>();

        MessageSource() {
        }

        public String getMessage(String key) {
            Localizer localizer = BeanValidator.this.context.getLocalizer();
            String prefix = BeanValidator.this.context.getValidatorKeyPrefix();
            String message = null;
            String resource = BeanValidator.this.context.getId() + "." + this.prefix(prefix, key);
            message = this.getString(localizer, resource, (Component)BeanValidator.this.context);
            if (Strings.isEmpty((CharSequence)message) && Strings.isEmpty((CharSequence)prefix)) {
                resource = BeanValidator.this.context.getId() + "." + key;
                message = this.getString(localizer, resource, (Component)BeanValidator.this.context);
            }
            if (Strings.isEmpty((CharSequence)message)) {
                resource = this.prefix(prefix, key);
                message = this.getString(localizer, resource, (Component)BeanValidator.this.context);
            }
            if (Strings.isEmpty((CharSequence)message)) {
                message = this.getString(localizer, key, (Component)BeanValidator.this.context);
            }
            if (Strings.isEmpty((CharSequence)message)) {
                message = null;
            }
            return message;
        }

        private String prefix(String prefix, String key) {
            if (!Strings.isEmpty((CharSequence)prefix)) {
                return prefix + "." + key;
            }
            return key;
        }

        private String getString(Localizer localizer, String key, Component component) {
            this.triedKeys.add(key);
            return localizer.getString(key, component, "");
        }

        public String substitute(String string, Map<String, Object> vars) throws IllegalStateException {
            return new MapVariableInterpolator(string, vars, Application.get().getResourceSettings().getThrowExceptionOnMissingResource()).toString();
        }
    }
}

