/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jsr303;

import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.AbstractPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;
import org.wicketstuff.jsr303.PropertyValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyValidation
extends Behavior {
    private static final long serialVersionUID = 1L;
    private boolean assigned = false;

    public synchronized void beforeRender(Component context) {
        if (!this.assigned) {
            this.assigned = true;
            if (context instanceof Form) {
                Form form = (Form)context;
                form.visitChildren((IVisitor)new JSR303ValidatorFormComponentVisitor());
            } else if (context instanceof FormComponent) {
                FormComponent fc = (FormComponent)context;
                PropertyValidation.addValidator(fc, false);
            } else {
                throw new IllegalStateException("Can only be applied to Forms or FormComponents");
            }
        }
        super.beforeRender(context);
    }

    private static <T> void addValidator(FormComponent<T> fc, boolean ignoreIncompatibleModel) {
        IModel model = fc.getModel();
        if (model != null) {
            if (model instanceof AbstractPropertyModel) {
                AbstractPropertyModel pm = (AbstractPropertyModel)model;
                PropertyValidator<T> validator = new PropertyValidator<T>(pm, fc);
                fc.add(validator);
            } else if (!ignoreIncompatibleModel) {
                throw new IllegalArgumentException("Expected something that provides an AbstractPropertyModel");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JSR303ValidatorFormComponentVisitor
    implements IVisitor<Component, Void> {
        JSR303ValidatorFormComponentVisitor() {
        }

        public void component(Component component, IVisit<Void> visit) {
            if (component instanceof FormComponent) {
                FormComponent fc = (FormComponent)component;
                PropertyValidation.addValidator(fc, true);
            }
        }
    }
}

