/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jsr303;

import javax.validation.ConstraintViolation;
import org.apache.wicket.validation.ValidationError;
import org.wicketstuff.jsr303.JSR303Validation;
import org.wicketstuff.jsr303.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ViolationErrorBuilder<T> {
    protected final ConstraintViolation<T> violation;

    ViolationErrorBuilder(ConstraintViolation<T> violation) {
        Assert.parameterNotNull(violation, "violation");
        this.violation = violation;
    }

    ValidationError createError() {
        ValidationError ve = new ValidationError();
        ve.setMessage(this.render());
        String messageTemplate = this.violation.getMessageTemplate();
        String key = ViolationErrorBuilder.extractKey(messageTemplate);
        if (key != null) {
            ve.addMessageKey(key);
        }
        return ve;
    }

    protected abstract String render();

    private static String extractKey(String messageTemplate) {
        Assert.parameterNotNull(messageTemplate, "messageTemplate");
        String key = messageTemplate.trim();
        if (key.startsWith("{") && key.endsWith("}")) {
            return key.substring(1, key.length() - 1);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Bean<T>
    extends ViolationErrorBuilder<T> {
        public Bean(ConstraintViolation<T> violation) {
            super(violation);
        }

        @Override
        protected String render() {
            return JSR303Validation.getViolationMessageRenderer().renderBeanViolation(this.violation);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Property<T>
    extends ViolationErrorBuilder<T> {
        public Property(ConstraintViolation<T> violation) {
            super(violation);
        }

        @Override
        protected String render() {
            return JSR303Validation.getViolationMessageRenderer().renderPropertyViolation(this.violation);
        }
    }
}

