/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.joda.convert.ReflectionStringConverter;

final class MethodConstructorStringConverter<T>
extends ReflectionStringConverter<T> {
    private final Constructor<T> fromString;

    MethodConstructorStringConverter(Class<T> cls, Method toString, Constructor<T> fromString) {
        super(cls, toString);
        if (cls.isInterface() || Modifier.isAbstract(cls.getModifiers()) || cls.isLocalClass() || cls.isMemberClass()) {
            throw new IllegalArgumentException("FromString constructor must be on an instantiable class");
        }
        if (fromString.getDeclaringClass() != cls) {
            throw new IllegalStateException("FromString constructor must be defined on specified class");
        }
        this.fromString = fromString;
    }

    @Override
    public T convertFromString(Class<? extends T> cls, String str) {
        try {
            return this.fromString.newInstance(str);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Constructor is not accessible");
        }
        catch (InstantiationException ex) {
            throw new IllegalStateException("Constructor is not valid");
        }
        catch (InvocationTargetException ex) {
            if (ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            throw new RuntimeException(ex.getMessage(), ex.getCause());
        }
    }
}

