/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.BasicChronology;
import org.joda.time.field.PreciseDurationDateTimeField;

final class BasicDayOfYearDateTimeField
extends PreciseDurationDateTimeField {
    private static final long serialVersionUID = -6821236822336841037L;
    private final BasicChronology iChronology;

    BasicDayOfYearDateTimeField(BasicChronology chronology, DurationField days) {
        super(DateTimeFieldType.dayOfYear(), days);
        this.iChronology = chronology;
    }

    @Override
    public int get(long instant) {
        return this.iChronology.getDayOfYear(instant);
    }

    @Override
    public DurationField getRangeDurationField() {
        return this.iChronology.years();
    }

    @Override
    public int getMinimumValue() {
        return 1;
    }

    @Override
    public int getMaximumValue() {
        return this.iChronology.getDaysInYearMax();
    }

    @Override
    public int getMaximumValue(long instant) {
        int year = this.iChronology.getYear(instant);
        return this.iChronology.getDaysInYear(year);
    }

    @Override
    public int getMaximumValue(ReadablePartial partial) {
        if (partial.isSupported(DateTimeFieldType.year())) {
            int year = partial.get(DateTimeFieldType.year());
            return this.iChronology.getDaysInYear(year);
        }
        return this.iChronology.getDaysInYearMax();
    }

    @Override
    public int getMaximumValue(ReadablePartial partial, int[] values) {
        int size = partial.size();
        for (int i = 0; i < size; ++i) {
            if (partial.getFieldType(i) != DateTimeFieldType.year()) continue;
            int year = values[i];
            return this.iChronology.getDaysInYear(year);
        }
        return this.iChronology.getDaysInYearMax();
    }

    @Override
    protected int getMaximumValueForSet(long instant, int value) {
        int maxLessOne = this.iChronology.getDaysInYearMax() - 1;
        return value > maxLessOne || value < 1 ? this.getMaximumValue(instant) : maxLessOne;
    }

    @Override
    public boolean isLeap(long instant) {
        return this.iChronology.isLeapDay(instant);
    }

    private Object readResolve() {
        return this.iChronology.dayOfYear();
    }
}

