/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DateTimeField;
import org.joda.time.field.DelegatedDateTimeField;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.LenientDateTimeField;

public class StrictDateTimeField
extends DelegatedDateTimeField {
    private static final long serialVersionUID = 3154803964207950910L;

    public static DateTimeField getInstance(DateTimeField field) {
        if (field == null) {
            return null;
        }
        if (field instanceof LenientDateTimeField) {
            field = ((LenientDateTimeField)field).getWrappedField();
        }
        if (!field.isLenient()) {
            return field;
        }
        return new StrictDateTimeField(field);
    }

    protected StrictDateTimeField(DateTimeField field) {
        super(field);
    }

    @Override
    public final boolean isLenient() {
        return false;
    }

    @Override
    public long set(long instant, int value) {
        FieldUtils.verifyValueBounds(this, value, this.getMinimumValue(instant), this.getMaximumValue(instant));
        return super.set(instant, value);
    }
}

