/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.tz;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.MutableDateTime;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.chrono.LenientChronology;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.joda.time.tz.DateTimeZoneBuilder;
import org.joda.time.tz.ZoneInfoLogger;

public class ZoneInfoCompiler {
    static DateTimeOfYear cStartOfYear;
    static Chronology cLenientISO;
    private Map<String, RuleSet> iRuleSets = new HashMap<String, RuleSet>();
    private List<Zone> iZones = new ArrayList<Zone>();
    private List<String> iGoodLinks = new ArrayList<String>();
    private List<String> iBackLinks = new ArrayList<String>();

    public static void main(String[] args) throws Exception {
        int i;
        if (args.length == 0) {
            ZoneInfoCompiler.printUsage();
            return;
        }
        File inputDir = null;
        File outputDir = null;
        boolean verbose = false;
        for (i = 0; i < args.length; ++i) {
            try {
                if ("-src".equals(args[i])) {
                    inputDir = new File(args[++i]);
                    continue;
                }
                if ("-dst".equals(args[i])) {
                    outputDir = new File(args[++i]);
                    continue;
                }
                if ("-verbose".equals(args[i])) {
                    verbose = true;
                    continue;
                }
                if (!"-?".equals(args[i])) break;
                ZoneInfoCompiler.printUsage();
                return;
            }
            catch (IndexOutOfBoundsException e) {
                ZoneInfoCompiler.printUsage();
                return;
            }
        }
        if (i >= args.length) {
            ZoneInfoCompiler.printUsage();
            return;
        }
        File[] sources = new File[args.length - i];
        int j = 0;
        while (i < args.length) {
            sources[j] = inputDir == null ? new File(args[i]) : new File(inputDir, args[i]);
            ++i;
            ++j;
        }
        ZoneInfoLogger.set(verbose);
        ZoneInfoCompiler zic = new ZoneInfoCompiler();
        zic.compile(outputDir, sources);
    }

    private static void printUsage() {
        System.out.println("Usage: java org.joda.time.tz.ZoneInfoCompiler <options> <source files>");
        System.out.println("where possible options include:");
        System.out.println("  -src <directory>    Specify where to read source files");
        System.out.println("  -dst <directory>    Specify where to write generated files");
        System.out.println("  -verbose            Output verbosely (default false)");
    }

    static DateTimeOfYear getStartOfYear() {
        if (cStartOfYear == null) {
            cStartOfYear = new DateTimeOfYear();
        }
        return cStartOfYear;
    }

    static Chronology getLenientISOChronology() {
        if (cLenientISO == null) {
            cLenientISO = LenientChronology.getInstance(ISOChronology.getInstanceUTC());
        }
        return cLenientISO;
    }

    static void writeZoneInfoMap(DataOutputStream dout, Map<String, DateTimeZone> zimap) throws IOException {
        String id;
        if (dout == null) {
            throw new IllegalArgumentException("DataOutputStream must not be null.");
        }
        HashMap<String, Short> idToIndex = new HashMap<String, Short>(zimap.size());
        TreeMap<Short, String> indexToId = new TreeMap<Short, String>();
        short count = 0;
        for (Map.Entry<String, DateTimeZone> entry : zimap.entrySet()) {
            Short index;
            id = entry.getKey();
            if (!idToIndex.containsKey(id)) {
                index = count;
                idToIndex.put(id, index);
                indexToId.put(index, id);
                count = (short)(count + 1);
                if (count == 0) {
                    throw new InternalError("Too many time zone ids");
                }
            }
            if (idToIndex.containsKey(id = entry.getValue().getID())) continue;
            index = count;
            idToIndex.put(id, index);
            indexToId.put(index, id);
            if ((count = (short)(count + 1)) != 0) continue;
            throw new InternalError("Too many time zone ids");
        }
        dout.writeShort(indexToId.size());
        for (String id2 : indexToId.values()) {
            dout.writeUTF(id2);
        }
        dout.writeShort(zimap.size());
        for (Map.Entry<String, DateTimeZone> entry : zimap.entrySet()) {
            id = entry.getKey();
            dout.writeShort(((Short)idToIndex.get(id)).shortValue());
            id = entry.getValue().getID();
            dout.writeShort(((Short)idToIndex.get(id)).shortValue());
        }
    }

    static int parseYear(String str, int def) {
        if ((str = str.toLowerCase(Locale.ENGLISH)).equals("minimum") || str.equals("min")) {
            return Integer.MIN_VALUE;
        }
        if (str.equals("maximum") || str.equals("max")) {
            return Integer.MAX_VALUE;
        }
        if (str.equals("only")) {
            return def;
        }
        return Integer.parseInt(str);
    }

    static int parseMonth(String str) {
        DateTimeField field = ISOChronology.getInstanceUTC().monthOfYear();
        return field.get(field.set(0L, str, Locale.ENGLISH));
    }

    static int parseDayOfWeek(String str) {
        DateTimeField field = ISOChronology.getInstanceUTC().dayOfWeek();
        return field.get(field.set(0L, str, Locale.ENGLISH));
    }

    static String parseOptional(String str) {
        return str.equals("-") ? null : str;
    }

    static int parseTime(String str) {
        int newPos;
        DateTimeFormatter p = ISODateTimeFormat.hourMinuteSecondFraction();
        MutableDateTime mdt = new MutableDateTime(0L, ZoneInfoCompiler.getLenientISOChronology());
        int pos = 0;
        if (str.startsWith("-")) {
            pos = 1;
        }
        if ((newPos = p.parseInto(mdt, str, pos)) == ~pos) {
            throw new IllegalArgumentException(str);
        }
        int millis = (int)mdt.getMillis();
        if (pos == 1) {
            millis = -millis;
        }
        return millis;
    }

    static char parseZoneChar(char c) {
        switch (c) {
            case 'S': 
            case 's': {
                return 's';
            }
            case 'G': 
            case 'U': 
            case 'Z': 
            case 'g': 
            case 'u': 
            case 'z': {
                return 'u';
            }
        }
        return 'w';
    }

    static boolean test(String id, DateTimeZone tz) {
        long prev;
        long next;
        if (!id.equals(tz.getID())) {
            return true;
        }
        long millis = ISOChronology.getInstanceUTC().year().set(0L, 1850);
        long end = ISOChronology.getInstanceUTC().year().set(0L, 2050);
        int offset = tz.getOffset(millis);
        int stdOffset = tz.getStandardOffset(millis);
        String key = tz.getNameKey(millis);
        ArrayList<Long> transitions = new ArrayList<Long>();
        while ((next = tz.nextTransition(millis)) != millis && next <= end) {
            millis = next;
            int nextOffset = tz.getOffset(millis);
            int nextStdOffset = tz.getStandardOffset(millis);
            String nextKey = tz.getNameKey(millis);
            if (offset == nextOffset && stdOffset == nextStdOffset && key.equals(nextKey)) {
                System.out.println("*d* Error in " + tz.getID() + " " + new DateTime(millis, (Chronology)ISOChronology.getInstanceUTC()));
                return false;
            }
            if (nextKey == null || nextKey.length() < 3 && !"??".equals(nextKey)) {
                System.out.println("*s* Error in " + tz.getID() + " " + new DateTime(millis, (Chronology)ISOChronology.getInstanceUTC()) + ", nameKey=" + nextKey);
                return false;
            }
            transitions.add(millis);
            offset = nextOffset;
            key = nextKey;
        }
        millis = ISOChronology.getInstanceUTC().year().set(0L, 2050);
        end = ISOChronology.getInstanceUTC().year().set(0L, 1850);
        int i = transitions.size();
        while (--i >= 0 && (prev = tz.previousTransition(millis)) != millis && prev >= end) {
            millis = prev;
            long trans = (Long)transitions.get(i);
            if (trans - 1L == millis) continue;
            System.out.println("*r* Error in " + tz.getID() + " " + new DateTime(millis, (Chronology)ISOChronology.getInstanceUTC()) + " != " + new DateTime(trans - 1L, (Chronology)ISOChronology.getInstanceUTC()));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, DateTimeZone> compile(File outputDir, File[] sources) throws IOException {
        int i;
        if (sources != null) {
            for (int i2 = 0; i2 < sources.length; ++i2) {
                try (BufferedReader in = null;){
                    in = new BufferedReader(new FileReader(sources[i2]));
                    this.parseDataFile(in, "backward".equals(sources[i2].getName()));
                    continue;
                }
            }
        }
        if (outputDir != null) {
            if (!outputDir.exists() && !outputDir.mkdirs()) {
                throw new IOException("Destination directory doesn't exist and cannot be created: " + outputDir);
            }
            if (!outputDir.isDirectory()) {
                throw new IOException("Destination is not a directory: " + outputDir);
            }
        }
        TreeMap<String, DateTimeZone> map = new TreeMap<String, DateTimeZone>();
        TreeMap<String, Zone> sourceMap = new TreeMap<String, Zone>();
        System.out.println("Writing zoneinfo files");
        for (i = 0; i < this.iZones.size(); ++i) {
            Zone zone = this.iZones.get(i);
            DateTimeZoneBuilder builder = new DateTimeZoneBuilder();
            zone.addToBuilder(builder, this.iRuleSets);
            DateTimeZone tz = builder.toDateTimeZone(zone.iName, true);
            if (!ZoneInfoCompiler.test(tz.getID(), tz)) continue;
            map.put(tz.getID(), tz);
            sourceMap.put(tz.getID(), zone);
            if (outputDir == null) continue;
            this.writeZone(outputDir, builder, tz);
        }
        for (i = 0; i < this.iGoodLinks.size(); i += 2) {
            String baseId = this.iGoodLinks.get(i);
            String alias = this.iGoodLinks.get(i + 1);
            Zone sourceZone = (Zone)sourceMap.get(baseId);
            if (sourceZone == null) {
                System.out.println("Cannot find source zone '" + baseId + "' to link alias '" + alias + "' to");
                continue;
            }
            DateTimeZoneBuilder builder = new DateTimeZoneBuilder();
            sourceZone.addToBuilder(builder, this.iRuleSets);
            DateTimeZone revived = builder.toDateTimeZone(alias, true);
            if (ZoneInfoCompiler.test(revived.getID(), revived)) {
                map.put(revived.getID(), revived);
                if (outputDir != null) {
                    this.writeZone(outputDir, builder, revived);
                }
            }
            map.put(revived.getID(), revived);
            if (!ZoneInfoLogger.verbose()) continue;
            System.out.println("Good link: " + alias + " -> " + baseId + " revived");
        }
        for (int pass = 0; pass < 2; ++pass) {
            for (int i3 = 0; i3 < this.iBackLinks.size(); i3 += 2) {
                String id = this.iBackLinks.get(i3);
                String alias = this.iBackLinks.get(i3 + 1);
                DateTimeZone tz = (DateTimeZone)map.get(id);
                if (tz == null) {
                    if (pass <= 0) continue;
                    System.out.println("Cannot find time zone '" + id + "' to link alias '" + alias + "' to");
                    continue;
                }
                map.put(alias, tz);
                if (!ZoneInfoLogger.verbose()) continue;
                System.out.println("Back link: " + alias + " -> " + tz.getID());
            }
        }
        if (outputDir != null) {
            System.out.println("Writing ZoneInfoMap");
            File file = new File(outputDir, "ZoneInfoMap");
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            FileOutputStream out = new FileOutputStream(file);
            try (DataOutputStream dout = new DataOutputStream(out);){
                TreeMap<String, DateTimeZone> zimap = new TreeMap<String, DateTimeZone>(String.CASE_INSENSITIVE_ORDER);
                zimap.putAll(map);
                ZoneInfoCompiler.writeZoneInfoMap(dout, zimap);
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeZone(File outputDir, DateTimeZoneBuilder builder, DateTimeZone tz) throws IOException {
        File file;
        if (ZoneInfoLogger.verbose()) {
            System.out.println("Writing " + tz.getID());
        }
        if (!(file = new File(outputDir, tz.getID())).getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try (FileOutputStream out = new FileOutputStream(file);){
            builder.writeTo(tz.getID(), out);
        }
        FileInputStream in = new FileInputStream(file);
        DateTimeZone tz2 = DateTimeZoneBuilder.readFrom(in, tz.getID());
        ((InputStream)in).close();
        if (!tz.equals(tz2)) {
            System.out.println("*e* Error in " + tz.getID() + ": Didn't read properly from file");
        }
    }

    public void parseDataFile(BufferedReader in, boolean backward) throws IOException {
        String line;
        Zone zone = null;
        while ((line = in.readLine()) != null) {
            String trimmed = line.trim();
            if (trimmed.length() == 0 || trimmed.charAt(0) == '#') continue;
            int index = line.indexOf(35);
            if (index >= 0) {
                line = line.substring(0, index);
            }
            StringTokenizer st = new StringTokenizer(line, " \t");
            if (Character.isWhitespace(line.charAt(0)) && st.hasMoreTokens()) {
                if (zone == null) continue;
                zone.chain(st);
                continue;
            }
            if (zone != null) {
                this.iZones.add(zone);
            }
            zone = null;
            if (!st.hasMoreTokens()) continue;
            String token = st.nextToken();
            if (token.equalsIgnoreCase("Rule")) {
                Rule r = new Rule(st);
                RuleSet rs = this.iRuleSets.get(r.iName);
                if (rs == null) {
                    rs = new RuleSet(r);
                    this.iRuleSets.put(r.iName, rs);
                    continue;
                }
                rs.addRule(r);
                continue;
            }
            if (token.equalsIgnoreCase("Zone")) {
                if (st.countTokens() < 4) {
                    throw new IllegalArgumentException("Attempting to create a Zone from an incomplete tokenizer");
                }
                zone = new Zone(st);
                continue;
            }
            if (token.equalsIgnoreCase("Link")) {
                String real = st.nextToken();
                String alias = st.nextToken();
                if (backward || alias.equals("US/Pacific-New") || alias.startsWith("Etc/") || alias.equals("GMT")) {
                    this.iBackLinks.add(real);
                    this.iBackLinks.add(alias);
                    continue;
                }
                this.iGoodLinks.add(real);
                this.iGoodLinks.add(alias);
                continue;
            }
            System.out.println("Unknown line: " + line);
        }
        if (zone != null) {
            this.iZones.add(zone);
        }
    }

    private static class Zone {
        public final String iName;
        public final int iOffsetMillis;
        public final String iRules;
        public final String iFormat;
        public final int iUntilYear;
        public final DateTimeOfYear iUntilDateTimeOfYear;
        private Zone iNext;

        Zone(StringTokenizer st) {
            this(st.nextToken(), st);
        }

        private Zone(String name, StringTokenizer st) {
            this.iName = name.intern();
            this.iOffsetMillis = ZoneInfoCompiler.parseTime(st.nextToken());
            this.iRules = ZoneInfoCompiler.parseOptional(st.nextToken());
            this.iFormat = st.nextToken().intern();
            int year = Integer.MAX_VALUE;
            DateTimeOfYear dtOfYear = ZoneInfoCompiler.getStartOfYear();
            if (st.hasMoreTokens()) {
                year = Integer.parseInt(st.nextToken());
                if (st.hasMoreTokens()) {
                    dtOfYear = new DateTimeOfYear(st);
                }
            }
            this.iUntilYear = year;
            this.iUntilDateTimeOfYear = dtOfYear;
        }

        void chain(StringTokenizer st) {
            if (this.iNext != null) {
                this.iNext.chain(st);
            } else {
                this.iNext = new Zone(this.iName, st);
            }
        }

        public void addToBuilder(DateTimeZoneBuilder builder, Map<String, RuleSet> ruleSets) {
            Zone.addToBuilder(this, builder, ruleSets);
        }

        private static void addToBuilder(Zone zone, DateTimeZoneBuilder builder, Map<String, RuleSet> ruleSets) {
            while (zone != null) {
                if (zone.iRules == null) {
                    builder.setStandardOffset(zone.iOffsetMillis);
                    builder.setFixedSavings(zone.iFormat, 0);
                } else {
                    try {
                        int saveMillis = ZoneInfoCompiler.parseTime(zone.iRules);
                        builder.setStandardOffset(zone.iOffsetMillis);
                        builder.setFixedSavings(zone.iFormat, saveMillis);
                    }
                    catch (Exception e) {
                        RuleSet rs = ruleSets.get(zone.iRules);
                        if (rs == null) {
                            throw new IllegalArgumentException("Rules not found: " + zone.iRules);
                        }
                        rs.addRecurring(builder, zone.iOffsetMillis, zone.iFormat);
                    }
                }
                if (zone.iUntilYear == Integer.MAX_VALUE) break;
                zone.iUntilDateTimeOfYear.addCutover(builder, zone.iUntilYear);
                zone = zone.iNext;
            }
        }

        public String toString() {
            String str = "[Zone]\nName: " + this.iName + "\nOffsetMillis: " + this.iOffsetMillis + "\nRules: " + this.iRules + "\nFormat: " + this.iFormat + "\nUntilYear: " + this.iUntilYear + "\n" + this.iUntilDateTimeOfYear;
            if (this.iNext == null) {
                return str;
            }
            return str + "...\n" + this.iNext.toString();
        }
    }

    private static class RuleSet {
        private List<Rule> iRules = new ArrayList<Rule>();

        RuleSet(Rule rule) {
            this.iRules.add(rule);
        }

        void addRule(Rule rule) {
            if (!rule.iName.equals(this.iRules.get((int)0).iName)) {
                throw new IllegalArgumentException("Rule name mismatch");
            }
            this.iRules.add(rule);
        }

        public void addRecurring(DateTimeZoneBuilder builder, int standardMillis, String nameFormat) {
            Rule rule;
            int i;
            int negativeSave = 0;
            for (i = 0; i < this.iRules.size(); ++i) {
                rule = this.iRules.get(i);
                if (rule.iSaveMillis >= 0) continue;
                negativeSave = Math.min(negativeSave, rule.iSaveMillis);
            }
            if (negativeSave < 0) {
                standardMillis += negativeSave;
                int slashPos = ((String)nameFormat).indexOf("/");
                if (slashPos > 0) {
                    nameFormat = ((String)nameFormat).substring(slashPos + 1) + "/" + ((String)nameFormat).substring(0, slashPos);
                }
            }
            builder.setStandardOffset(standardMillis);
            for (i = 0; i < this.iRules.size(); ++i) {
                rule = this.iRules.get(i);
                rule.addRecurring(builder, negativeSave, (String)nameFormat);
            }
        }
    }

    private static class Rule {
        public final String iName;
        public final int iFromYear;
        public final int iToYear;
        public final String iType;
        public final DateTimeOfYear iDateTimeOfYear;
        public final int iSaveMillis;
        public final String iLetterS;

        Rule(StringTokenizer st) {
            if (st.countTokens() < 6) {
                throw new IllegalArgumentException("Attempting to create a Rule from an incomplete tokenizer");
            }
            this.iName = st.nextToken().intern();
            this.iFromYear = ZoneInfoCompiler.parseYear(st.nextToken(), 0);
            this.iToYear = ZoneInfoCompiler.parseYear(st.nextToken(), this.iFromYear);
            if (this.iToYear < this.iFromYear) {
                throw new IllegalArgumentException();
            }
            this.iType = ZoneInfoCompiler.parseOptional(st.nextToken());
            this.iDateTimeOfYear = new DateTimeOfYear(st);
            this.iSaveMillis = ZoneInfoCompiler.parseTime(st.nextToken());
            this.iLetterS = ZoneInfoCompiler.parseOptional(st.nextToken());
        }

        public void addRecurring(DateTimeZoneBuilder builder, int negativeSave, String nameFormat) {
            int saveMillis = this.iSaveMillis + -negativeSave;
            String nameKey = Rule.formatName(nameFormat, saveMillis, this.iLetterS);
            this.iDateTimeOfYear.addRecurring(builder, nameKey, saveMillis, this.iFromYear, this.iToYear);
        }

        private static String formatName(String nameFormat, int saveMillis, String letterS) {
            int index = nameFormat.indexOf(47);
            if (index > 0) {
                if (saveMillis == 0) {
                    return nameFormat.substring(0, index).intern();
                }
                return nameFormat.substring(index + 1).intern();
            }
            index = nameFormat.indexOf("%s");
            if (index < 0) {
                return nameFormat;
            }
            String left = nameFormat.substring(0, index);
            String right = nameFormat.substring(index + 2);
            Object name = letterS == null ? left.concat(right) : left + letterS + right;
            return ((String)name).intern();
        }

        public String toString() {
            return "[Rule]\nName: " + this.iName + "\nFromYear: " + this.iFromYear + "\nToYear: " + this.iToYear + "\nType: " + this.iType + "\n" + this.iDateTimeOfYear + "SaveMillis: " + this.iSaveMillis + "\nLetterS: " + this.iLetterS + "\n";
        }
    }

    static class DateTimeOfYear {
        public final int iMonthOfYear;
        public final int iDayOfMonth;
        public final int iDayOfWeek;
        public final boolean iAdvanceDayOfWeek;
        public final int iMillisOfDay;
        public final char iZoneChar;

        DateTimeOfYear() {
            this.iMonthOfYear = 1;
            this.iDayOfMonth = 1;
            this.iDayOfWeek = 0;
            this.iAdvanceDayOfWeek = false;
            this.iMillisOfDay = 0;
            this.iZoneChar = (char)119;
        }

        DateTimeOfYear(StringTokenizer st) {
            int month = 1;
            int day = 1;
            int dayOfWeek = 0;
            int millis = 0;
            boolean advance = false;
            int zoneChar = 119;
            if (st.hasMoreTokens()) {
                month = ZoneInfoCompiler.parseMonth(st.nextToken());
                if (st.hasMoreTokens()) {
                    String str = st.nextToken();
                    if (str.startsWith("last")) {
                        day = -1;
                        dayOfWeek = ZoneInfoCompiler.parseDayOfWeek(str.substring(4));
                        advance = false;
                    } else {
                        try {
                            day = Integer.parseInt(str);
                            dayOfWeek = 0;
                            advance = false;
                        }
                        catch (NumberFormatException e) {
                            int index = str.indexOf(">=");
                            if (index > 0) {
                                day = Integer.parseInt(str.substring(index + 2));
                                dayOfWeek = ZoneInfoCompiler.parseDayOfWeek(str.substring(0, index));
                                advance = true;
                            }
                            index = str.indexOf("<=");
                            if (index > 0) {
                                day = Integer.parseInt(str.substring(index + 2));
                                dayOfWeek = ZoneInfoCompiler.parseDayOfWeek(str.substring(0, index));
                                advance = false;
                            }
                            throw new IllegalArgumentException(str);
                        }
                    }
                    if (st.hasMoreTokens()) {
                        str = st.nextToken();
                        zoneChar = ZoneInfoCompiler.parseZoneChar(str.charAt(str.length() - 1));
                        if (str.equals("24:00")) {
                            if (month == 12 && day == 31) {
                                millis = ZoneInfoCompiler.parseTime("23:59:59.999");
                            } else {
                                LocalDate date = day == -1 ? new LocalDate(2001, month, 1).plusMonths(1) : new LocalDate(2001, month, day).plusDays(1);
                                advance = day != -1 && dayOfWeek != 0;
                                month = date.getMonthOfYear();
                                day = date.getDayOfMonth();
                                if (dayOfWeek != 0) {
                                    dayOfWeek = (dayOfWeek - 1 + 1) % 7 + 1;
                                }
                            }
                        } else {
                            millis = ZoneInfoCompiler.parseTime(str);
                        }
                    }
                }
            }
            this.iMonthOfYear = month;
            this.iDayOfMonth = day;
            this.iDayOfWeek = dayOfWeek;
            this.iAdvanceDayOfWeek = advance;
            this.iMillisOfDay = millis;
            this.iZoneChar = (char)zoneChar;
        }

        public void addRecurring(DateTimeZoneBuilder builder, String nameKey, int saveMillis, int fromYear, int toYear) {
            builder.addRecurringSavings(nameKey, saveMillis, fromYear, toYear, this.iZoneChar, this.iMonthOfYear, this.iDayOfMonth, this.iDayOfWeek, this.iAdvanceDayOfWeek, this.iMillisOfDay);
        }

        public void addCutover(DateTimeZoneBuilder builder, int year) {
            builder.addCutover(year, this.iZoneChar, this.iMonthOfYear, this.iDayOfMonth, this.iDayOfWeek, this.iAdvanceDayOfWeek, this.iMillisOfDay);
        }

        public String toString() {
            return "MonthOfYear: " + this.iMonthOfYear + "\nDayOfMonth: " + this.iDayOfMonth + "\nDayOfWeek: " + this.iDayOfWeek + "\nAdvanceDayOfWeek: " + this.iAdvanceDayOfWeek + "\nMillisOfDay: " + this.iMillisOfDay + "\nZoneChar: " + this.iZoneChar + "\n";
        }
    }
}

