/*
 * Decompiled with CFR 0.152.
 */
package org.xolstice.maven.plugin.protobuf;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.annotations.Parameter;
import org.xolstice.maven.plugin.protobuf.AbstractProtocMojo;

public abstract class AbstractProtocCompileMojo
extends AbstractProtocMojo {
    @Parameter(required=true, defaultValue="${basedir}/src/main/proto")
    private File protoSourceRoot;
    @Parameter(required=true, defaultValue="${project.build.directory}/generated-resources/protobuf/descriptor-sets")
    private File descriptorSetOutputDirectory;
    @Parameter(required=false)
    protected String descriptorSetClassifier;

    @Override
    protected void doAttachProtoSources() {
        this.projectHelper.addResource(this.project, this.getProtoSourceRoot().getAbsolutePath(), (List)ImmutableList.copyOf(this.getIncludes()), (List)ImmutableList.copyOf(this.getExcludes()));
    }

    @Override
    protected void doAttachGeneratedFiles() {
        File outputDirectory = this.getOutputDirectory();
        this.project.addCompileSourceRoot(outputDirectory.getAbsolutePath());
        if (this.writeDescriptorSet) {
            File descriptorSetFile = new File(this.getDescriptorSetOutputDirectory(), this.descriptorSetFileName);
            this.projectHelper.attachArtifact(this.project, "protobin", this.descriptorSetClassifier, descriptorSetFile);
        }
        this.buildContext.refresh(outputDirectory);
    }

    @Override
    protected List<Artifact> getDependencyArtifacts() {
        return this.project.getCompileArtifacts();
    }

    @Override
    protected File getDescriptorSetOutputDirectory() {
        return this.descriptorSetOutputDirectory;
    }

    @Override
    protected File getProtoSourceRoot() {
        return this.protoSourceRoot;
    }
}

