/*
 * Decompiled with CFR 0.152.
 */
package org.xolstice.maven.plugin.protobuf;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.toolchain.Toolchain;
import org.xolstice.maven.plugin.protobuf.AbstractProtocCompileMojo;
import org.xolstice.maven.plugin.protobuf.Protoc;

@Mojo(name="compile-custom", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public final class ProtocCompileCustomMojo
extends AbstractProtocCompileMojo {
    @Parameter(required=true, property="protocPluginId")
    private String pluginId;
    @Parameter(required=true, readonly=true, defaultValue="${project.build.directory}/generated-sources/protobuf")
    private File outputBaseDirectory;
    @Parameter(required=false, property="protocPluginOutputDirectory")
    private File outputDirectory;
    @Parameter(required=false, property="protocPluginExecutable")
    private String pluginExecutable;
    @Parameter(required=false, property="protocPluginParameter")
    private String pluginParameter;
    @Parameter(required=false, property="protocPluginToolchain")
    private String pluginToolchain;
    @Parameter(required=false, property="protocPluginTool")
    private String pluginTool;
    @Parameter(required=false, property="protocPluginArtifact")
    private String pluginArtifact;

    @Override
    protected void addProtocBuilderParameters(Protoc.Builder protocBuilder) throws MojoExecutionException {
        Toolchain tc;
        super.addProtocBuilderParameters(protocBuilder);
        protocBuilder.setNativePluginId(this.pluginId);
        if (this.pluginToolchain != null && this.pluginTool != null && (tc = this.toolchainManager.getToolchainFromBuildContext(this.pluginToolchain, this.session)) != null) {
            this.getLog().info((CharSequence)("Toolchain in protobuf-maven-plugin: " + tc));
            if (this.pluginExecutable != null) {
                this.getLog().warn((CharSequence)("Toolchains are ignored, 'pluginExecutable' parameter is set to " + this.pluginExecutable));
            } else {
                this.pluginExecutable = tc.findTool(this.pluginTool);
            }
        }
        if (this.pluginExecutable == null && this.pluginArtifact != null) {
            Artifact artifact = this.createDependencyArtifact(this.pluginArtifact);
            File file = this.resolveBinaryArtifact(artifact);
            this.pluginExecutable = file.getAbsolutePath();
        }
        if (this.pluginExecutable != null) {
            protocBuilder.setNativePluginExecutable(this.pluginExecutable);
        }
        if (this.pluginParameter != null) {
            protocBuilder.setNativePluginParameter(this.pluginParameter);
        }
        protocBuilder.setCustomOutputDirectory(this.getOutputDirectory());
    }

    @Override
    protected File getOutputDirectory() {
        File outputDirectory = this.outputDirectory;
        if (outputDirectory == null) {
            outputDirectory = new File(this.outputBaseDirectory, this.pluginId);
        }
        return outputDirectory;
    }
}

