/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem.spring.web.advice;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletResponse;
import org.apiguardian.api.API;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.context.request.NativeWebRequest;
import org.zalando.fauxpas.FauxPas;
import org.zalando.problem.Problem;
import org.zalando.problem.Status;
import org.zalando.problem.StatusType;
import org.zalando.problem.ThrowableProblem;
import org.zalando.problem.spring.common.AdviceTraits;
import org.zalando.problem.spring.web.advice.ContentNegotiation;

@API(status=API.Status.STABLE)
public interface AdviceTrait
extends org.zalando.problem.spring.common.AdviceTrait {
    default public ResponseEntity<Problem> create(Throwable throwable, NativeWebRequest request) {
        ThrowableProblem problem = this.toProblem(throwable);
        return this.create(throwable, (Problem)problem, request);
    }

    default public ResponseEntity<Problem> create(StatusType status, Throwable throwable, NativeWebRequest request) {
        return this.create(status, throwable, request, new HttpHeaders());
    }

    default public ResponseEntity<Problem> create(StatusType status, Throwable throwable, NativeWebRequest request, HttpHeaders headers) {
        return this.create(throwable, (Problem)this.toProblem(throwable, status), request, headers);
    }

    default public ResponseEntity<Problem> create(StatusType status, Throwable throwable, NativeWebRequest request, URI type) {
        return this.create(status, throwable, request, new HttpHeaders(), type);
    }

    default public ResponseEntity<Problem> create(StatusType status, Throwable throwable, NativeWebRequest request, HttpHeaders headers, URI type) {
        return this.create(throwable, (Problem)this.toProblem(throwable, status, type), request, headers);
    }

    default public ResponseEntity<Problem> create(ThrowableProblem problem, NativeWebRequest request) {
        return this.create(problem, request, new HttpHeaders());
    }

    default public ResponseEntity<Problem> create(ThrowableProblem problem, NativeWebRequest request, HttpHeaders headers) {
        return this.create((Throwable)problem, (Problem)problem, request, headers);
    }

    default public ResponseEntity<Problem> create(Throwable throwable, Problem problem, NativeWebRequest request) {
        return this.create(throwable, problem, request, new HttpHeaders());
    }

    default public ResponseEntity<Problem> create(Throwable throwable, Problem problem, NativeWebRequest request, HttpHeaders headers) {
        HttpStatus status = HttpStatus.valueOf((int)Optional.ofNullable(problem.getStatus()).orElse((StatusType)Status.INTERNAL_SERVER_ERROR).getStatusCode());
        this.log(throwable, problem, request, status);
        if (status == HttpStatus.INTERNAL_SERVER_ERROR) {
            request.setAttribute("javax.servlet.error.exception", (Object)throwable, 0);
        }
        return this.process((ResponseEntity<Problem>)this.negotiate(request).map(contentType -> ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)status).headers(headers)).contentType(contentType).body((Object)problem)).orElseGet((Supplier<ResponseEntity>)FauxPas.throwingSupplier(() -> {
            ResponseEntity<Problem> fallback = this.fallback(throwable, problem, request, headers);
            if (fallback.getBody() == null) {
                ServletServerHttpResponse response = new ServletServerHttpResponse((HttpServletResponse)request.getNativeResponse(HttpServletResponse.class));
                response.setStatusCode(fallback.getStatusCode());
                response.getHeaders().putAll((Map)fallback.getHeaders());
                response.getBody();
                response.flush();
            }
            return fallback;
        })), request);
    }

    default public void log(Throwable throwable, Problem problem, NativeWebRequest request, HttpStatus status) {
        AdviceTraits.log((Throwable)throwable, (HttpStatus)status);
    }

    default public Optional<MediaType> negotiate(NativeWebRequest request) {
        ContentNegotiationStrategy negotiator = ContentNegotiation.DEFAULT;
        List mediaTypes = negotiator.resolveMediaTypes(request);
        return AdviceTraits.getProblemMediaType((List)mediaTypes);
    }

    default public ResponseEntity<Problem> fallback(Throwable throwable, Problem problem, NativeWebRequest request, HttpHeaders headers) {
        return AdviceTraits.fallback((Problem)problem, (HttpHeaders)headers);
    }

    default public ResponseEntity<Problem> process(ResponseEntity<Problem> entity, NativeWebRequest request) {
        return this.process(entity);
    }
}

