package jd.api.request.aftersale;


import java.io.Serializable;

/**
 * Created by xiaoxu on 2016年8月25日
 */
public class AfsApplyEntity implements Serializable {

    /**
     * 订单号 Y
     */
    private Long jdOrderId;

    /**
     * 客户预期 Y
     * 退货(10)、换货(20)、维修(30)
     */
    private Integer customerExpect;

    /**
     * 产品问题描述 Y
     */
    private String questionDesc;

    /**
     * 是否需要检测报告 Y
     */
    private Boolean isNeedDetectionReport;

    /**
     * 问题描述图片 N
     */
    private String questionPic;

    /**
     * 是否有包装 N
     */
    private Boolean isHasPackage;

    /**
     * 包装描述 N
     * 0 无包装
     * 10 包装完整
     * 20 包装破损
     */
    private Integer packageDesc;

    /**
     * 客户信息实体 Y
     */
    private AfterSaleCustomerDto asCustomerDto;

    /**
     * 取件信息实体 Y
     */
    private AfterSalePickwareDto asPickwareDto;

    /**
     * 返件信息实体 Y
     */
    private AfterSaleReturnwareDto asReturnwareDto;

    /**
     * 申请单明细 Y
     */
    private AfterSaleDetailDto asDetailDto;

    public AfsApplyEntity() {
    }

    /**
     * 必填参数构造
     */
    public AfsApplyEntity(Long jdOrderId, Integer customerExpect, String questionDesc,
                          Boolean isNeedDetectionReport, AfterSaleCustomerDto asCustomerDto,
                          AfterSalePickwareDto asPickwareDto,
                          AfterSaleReturnwareDto asReturnwareDto,
                          AfterSaleDetailDto asDetailDto) {
        this.jdOrderId = jdOrderId;
        this.customerExpect = customerExpect;
        this.questionDesc = questionDesc;
        this.isNeedDetectionReport = isNeedDetectionReport;
        this.asCustomerDto = asCustomerDto;
        this.asPickwareDto = asPickwareDto;
        this.asReturnwareDto = asReturnwareDto;
        this.asDetailDto = asDetailDto;
    }

    /**
     * 全参构造
     */
    public AfsApplyEntity(Long jdOrderId, Integer customerExpect,
                          String questionDesc, Boolean isNeedDetectionReport,
                          String questionPic, Boolean isHasPackage, Integer packageDesc,
                          AfterSaleCustomerDto asCustomerDto,
                          AfterSalePickwareDto asPickwareDto,
                          AfterSaleReturnwareDto asReturnwareDto,
                          AfterSaleDetailDto asDetailDto) {
        this.jdOrderId = jdOrderId;
        this.customerExpect = customerExpect;
        this.questionDesc = questionDesc;
        this.isNeedDetectionReport = isNeedDetectionReport;
        this.questionPic = questionPic;
        this.isHasPackage = isHasPackage;
        this.packageDesc = packageDesc;
        this.asCustomerDto = asCustomerDto;
        this.asPickwareDto = asPickwareDto;
        this.asReturnwareDto = asReturnwareDto;
        this.asDetailDto = asDetailDto;
    }

    public Long getJdOrderId() {
        return jdOrderId;
    }

    public void setJdOrderId(Long jdOrderId) {
        this.jdOrderId = jdOrderId;
    }

    public Integer getCustomerExpect() {
        return customerExpect;
    }

    public void setCustomerExpect(Integer customerExpect) {
        this.customerExpect = customerExpect;
    }

    public String getQuestionDesc() {
        return questionDesc;
    }

    public void setQuestionDesc(String questionDesc) {
        this.questionDesc = questionDesc;
    }

    public Boolean getIsNeedDetectionReport() {
        return isNeedDetectionReport;
    }

    public void setIsNeedDetectionReport(Boolean isNeedDetectionReport) {
        this.isNeedDetectionReport = isNeedDetectionReport;
    }

    public String getQuestionPic() {
        return questionPic;
    }

    public void setQuestionPic(String questionPic) {
        this.questionPic = questionPic;
    }

    public Boolean getIsHasPackage() {
        return isHasPackage;
    }

    public void setIsHasPackage(Boolean isHasPackage) {
        this.isHasPackage = isHasPackage;
    }

    public Integer getPackageDesc() {
        return packageDesc;
    }

    public void setPackageDesc(Integer packageDesc) {
        this.packageDesc = packageDesc;
    }

    public AfterSaleCustomerDto getAsCustomerDto() {
        return asCustomerDto;
    }

    public void setAsCustomerDto(AfterSaleCustomerDto asCustomerDto) {
        this.asCustomerDto = asCustomerDto;
    }

    public AfterSalePickwareDto getAsPickwareDto() {
        return asPickwareDto;
    }

    public void setAsPickwareDto(AfterSalePickwareDto asPickwareDto) {
        this.asPickwareDto = asPickwareDto;
    }

    public AfterSaleReturnwareDto getAsReturnwareDto() {
        return asReturnwareDto;
    }

    public void setAsReturnwareDto(AfterSaleReturnwareDto asReturnwareDto) {
        this.asReturnwareDto = asReturnwareDto;
    }

    public AfterSaleDetailDto getAsDetailDto() {
        return asDetailDto;
    }

    public void setAsDetailDto(AfterSaleDetailDto asDetailDto) {
        this.asDetailDto = asDetailDto;
    }

}
