package jd.api.service.aftersale;

import jd.api.request.aftersale.AfsApplyEntity;
import jd.api.request.aftersale.AuditCancelEntity;
import jd.api.request.aftersale.OrderSkuEntity;
import jd.api.request.aftersale.SendSkuEntity;
import jd.api.request.aftersale.ServiceDetailInfoEntity;
import jd.api.request.aftersale.ServiceListPageEntity;
import jd.api.response.aftersale.AfsApplyResp;
import jd.api.response.aftersale.AuditCancelResp;
import jd.api.response.aftersale.AvailableNumberCompResp;
import jd.api.response.aftersale.CustomerExpectCompResp;
import jd.api.response.aftersale.SendSkuResp;
import jd.api.response.aftersale.ServiceDetailInfoResp;
import jd.api.response.aftersale.ServiceListPageResp;
import jd.api.response.aftersale.WareReturnJdCompResp;

/**
 * Created by xujingfeng on 2016年10月26日
 */
public interface JdAftersaleApi {

	/**
	 * 3.1	服务单保存申请
	 * 注意取得不是result 是resultCode
	 * resultCode	异常代码Key		
	 * 0无错误信息
	 * 2000 创建失败
	 * 6000:网络异常，请稍后重试,
	 * 6001:参数不正确,
	 * 6002:该订单不存在, 
	 * 6003:该订单未确认提交, 6004:该订单不是子订单, 
	 * 6005:该订单未妥投, 
	 * 6006:该订单不是正常订单, 
	 * 6007:订单没有该商品编号, 
	 * 6008:该订单是未完成订单, 
	 * 6009:订单中某商品不可以提交售后服务, 
	 * 6010:数量超过订单商品数量, 
	 * 6011:不属于商品返回京东方式, 
	 * 6012:不属于支持的服务类型, 
	 * 6013:服务单未通过审核;
	 * @param afsApplyEntity
	 * @return AfsApplyResp
	 */
	AfsApplyResp createServiceTicket(AfsApplyEntity afsApplyEntity);

	/**
	 * 3.2	填写客户发运信息
	 * @param sendSkuEntity
	 * @return SendSkuResp
	 */
	SendSkuResp sendSku(SendSkuEntity sendSkuEntity);

	/**
	 * 3.3	校验某订单中某商品是否可以提交售后服务
	 * @param orderSkuEntity
	 * @return AvailableNumberCompResp
	 */
	AvailableNumberCompResp getAvailableNumber(OrderSkuEntity orderSkuEntity);

	/**
	 * 3.4	根据订单号、商品编号查询支持的服务类型
	 * @param orderSkuEntity
	 * @return CustomerExpectCompResp
	 */
	CustomerExpectCompResp getCustomerExpect(OrderSkuEntity orderSkuEntity);

	/**
	 * 3.5	根据订单号、商品编号查询支持的商品返回京东方式
	 * @param orderSkuEntity
	 * @return WareReturnJdCompResp
	 */
	WareReturnJdCompResp getWareReturnJd(OrderSkuEntity orderSkuEntity);

	/**
	 * 3.6	根据客户账号和订单号分页查询服务单概要信息
	 * @param serviceListPageEntity
	 * @return ServiceListPageResp
	 */
	ServiceListPageResp getServiceListPage(ServiceListPageEntity serviceListPageEntity);

	/**
	 * 3.7	根据服务单号查询服务单明细信息
	 * @param serviceDetailInfoEntity
	 * @return
	 */
	ServiceDetailInfoResp getServiceDetailInfo(ServiceDetailInfoEntity serviceDetailInfoEntity);

	/**
	 * 3.8	取消服务单/客户放弃
	 * @param auditCancelEntity
	 * @return AuditCancelResp
	 */
	AuditCancelResp cancelAudit(AuditCancelEntity auditCancelEntity);

}