package jd.api.service.order;

import jd.api.request.order.*;
import jd.api.response.order.*;
import jd.api.vo.order.OrderFreightVO;
import sinomall.global.common.vo.outsideapi.OrderCancelOrderResp;

import java.util.Map;

/**
 * Created by xujingfeng on 2016年10月26日
 */
public interface JdOrderApi {

    /**
     * 2.1 统一下单接口
     *
     * @param orderEntity
     * @return
     */
    OrderUniteSubmitResp placeOrder(OrderEntity orderEntity);

    /**
     * 2.2.1 确认预占库存订单接口
     *
     * @param
     * @return
     */
    OccupyStockResp confirmOccupyStock(JdOrderIdEntity jdOrderIdEntity);

    /**
     * 2.2.3 取消未确认订单接口
     *
     * @param jdOrderIdEntity
     * @return
     */
    OrderCancelOrderResp cancelOrder(JdOrderIdEntity jdOrderIdEntity);

    /**
     * 2.2.4 查询京东订单信息接口
     *
     * @param jdOrderIdEntity
     * @return
     */
    Map<String, Object> queryOrder(JdOrderIdEntity jdOrderIdEntity);

    /**
     * 1.1.10 运费查询接口（新增）
     *
     * @param orderFreightEntity
     * @return
     */
    OrderFreightResp queryFreight(OrderFreightEntity orderFreightEntity);

    /**
     * 2.2.5 订单反查接口
     *
     * @param thirdOrder
     * @return
     */
    OrderRevResp queryOrderByThirdOrder(ThirdOrder thirdOrder);

    CheckOrderResp checkNewOrder(CheckOrderEntity checkOrderEntity);

    CheckOrderResp checkDlokOrder(CheckOrderEntity checkOrderEntity);

    CheckOrderResp checkRefuseOrder(CheckOrderEntity checkOrderEntity);

    /**
     * 2.2.6	查询配送信息接口
     *
     * @param jdOrderIdEntity
     * @return
     */
    OrderTrackResp queryOrderTrack(JdOrderIdEntity jdOrderIdEntity);


    Map<String, Object> getBalance(OrderBalanceEntity orderBalanceEntity);

    String toString();
}