package jd.api.service.product;

import jd.api.request.product.*;
import jd.api.response.product.CategoryResp;
import jd.api.response.product.CategorysResp;
import jd.api.response.product.ProductCheckResp;
import jd.api.vo.product.*;
import jd.dto.StockStateDto;

import java.util.List;
import java.util.Map;

/**
 * Created by xujingfeng on 2016年10月26日
 */
public interface JdProductApi {

	/**
	 * 1.1.1 查询所有商品池
	 * 
	 * @return
	 * @throws Exception
	 */
	List<ProductPoolVO> getProductPool();

	/**
	 * 1.1.2 查询池内商品编号
	 * 
	 * @return 商品编号的列表
	 * @throws Exception
	 */
	List<Long> getProductPoolProduct(PageNumEntity pageNumEntity);

	/**
	 * 1.1.2 查询池内商品编号
	 *
	 * 查询返回列表
	 * @return 商品编号的列表
	 * @throws Exception
	 */
	String getProductPoolProductResult(PageNumEntity pageNumEntity);

	/**
	 * 1.1.2 查询池内商品编号
	 *
	 * @return 商品编号的列表
	 * @throws Exception
	 */
	List<Long> getProductPoolProductOld(PageNumEntity pageNumEntity);

	/**
	 * 1.1.3 查询具体商品信息
	 * 
	 * @return 单个商品信息
	 * @throws Exception
	 */
	ProductDetailVO getProductDetail(ProductDetailEntity productDetailEntity);

	/**
	 * 1.1.4 查询商品上下架状态接口
	 * 
	 * @param skus
	 * @return
	 * @throws Exception
	 */
	List<ProductStateVO> getProductState(List<Long> skus);

	/**
	 * 1.1.5 查询所有图片信息接口
	 * 
	 * @param skus
	 * @return
	 * @throws Exception
	 */
	Map<Long, List<ProductSkuImageVO>> getProductSkuImage(List<Long> skus);

	/**
	 * 1.1.6 查询商品好评度接口
	 * 
	 * @param skus
	 * @return
	 * @throws Exception
	 */
	List<ProductCommentSummarysVO> getProductCommentSummarys(List<Long> skus);

	/**
	 * 1.1.7 查询商品区域购买限制接口
	 * 
	 * @return
	 * @throws Exception
	 */
	List<SkuIdsAndAreaVO> getProductLimit(SkuIdsAndAreaEntity skuIdsAndAreaEntity);

	/**
	 * 1.1.8 查询商品区域是否支持货到付款接口
	 * 
	 * @return
	 * @throws Exception
	 */
	Boolean getProductIsCod(SkuIdsAndAreaEntity skuIdsAndAreaEntity);

	/**
	 * 1.1.11	商品可售验证接口（新增）
	 * @param skus
	 * @return
	 */
	ProductCheckResp getSkuCheck(List<Long> skus);

	/**
	 * 3.17 同类商品查询
	 * @param skuEntity
	 * @return
	 */
    List<SimilarProduct> getSimilarProduct(String skuId);

    /**
	 * 1.2.1 批量查询价格
	 * 
	 * @param skuEntity
	 * @return
	 * @throws Exception
	 */
	List<PriceVO> getPrice(SkuEntity skuEntity);

	/**
	 * 1.4.1 批量获取库存接口
	 * 
	 * @param stockForOrderEntity
	 * @return
	 * @throws Exception
	 */
	List<StockNewResultVo> getStockForOrder(StockForOrderEntity stockForOrderEntity);

	/**
	 * 1.5.1 信息推送接口
	 * 
	 * @param messageTypeEntity
	 * @return
	 * @throws Exception
	 */
	List<MessageGetVO> getMessage(MessageTypeEntity messageTypeEntity);

	/**
	 * 1.5.2 删除推送信息接口
	 * 
	 * @param messageDelEntity
	 * @throws Exception
	 */
	Boolean delMessage(MessageDelEntity messageDelEntity);

	/**
	 * 1.1.14 查询分类列表信息接口
	 * @param categoryEntity
	 * @return
     */
	CategoryResp getCategory(CategoryEntity categoryEntity);



	/**
	 * 1.1.15 查询分类信息接口
	 * @param categorysEntity
	 * @return
	 */
	CategorysResp getCategorys(CategorysEntity categorysEntity);


	public String addJdGood(Long sku);

	void refreshCtStock();

	public List<StockStateDto> findBySku(String sku);

    public void save(StockStateDto stockState);

	public void executorsPoolAdd(List<Long> productNosList,int totalNum,Boolean isThread,Integer poolSize);

    Map addProdBySkus(Map returnMap, String skus);
}