package jdek.api.request;

import jdek.api.vo.JdekSkuVo;

import java.io.Serializable;
import java.util.ArrayList;

/**
 * Created by bande on 2017/7/13.
 */
public class JdekOrderEntity implements Serializable {
    /**
     * 第三方订单号
     */
    private String thirdOrder;
    /**
     * 商品sku
     */
    private ArrayList<JdekSkuVo> Sku;
    /**
     * 手机号
     * 手机号可以设置ifSendMsg为false不传该字段。
      如果不传该字段则不会发送短信，且补发短信接口无效
     */
    private String mobile;
    /**
     * 支付方式 (4：预存款，7:网银钱包， 101金采)
     */
    private Integer paymentType;
    /**
     * 是否发送短信 true:发送短信，需要填写mobile字段，false不发短信
     */
    private Boolean ifSendMsg;

    public JdekOrderEntity() {
    }

    public JdekOrderEntity(String thirdOrder, ArrayList<JdekSkuVo> sku, String mobile, Integer paymentType, Boolean ifSendMsg) {
        this.thirdOrder = thirdOrder;
        Sku = sku;
        this.mobile = mobile;
        this.paymentType = paymentType;
        this.ifSendMsg = ifSendMsg;
    }

    public String getThirdOrder() {
        return thirdOrder;
    }

    public void setThirdOrder(String thirdOrder) {
        this.thirdOrder = thirdOrder;
    }

    public ArrayList<JdekSkuVo> getSku() {
        return Sku;
    }

    public void setSku(ArrayList<JdekSkuVo> sku) {
        Sku = sku;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public Integer getPaymentType() {
        return paymentType;
    }

    public void setPaymentType(Integer paymentType) {
        this.paymentType = paymentType;
    }

    public Boolean getIfSendMsg() {
        return ifSendMsg;
    }

    public void setIfSendMsg(Boolean ifSendMsg) {
        this.ifSendMsg = ifSendMsg;
    }
}
