package jdek.api.service;

import jdek.api.request.*;
import jdek.api.response.JdekDelMessageResp;
import jdek.api.response.JdekGetMessageResp;
import jdek.api.response.JdekRepayResp;
import jdek.api.vo.*;

import java.util.ArrayList;

/**
 * Created by bande on 2017/7/14.
 */
public interface JdekApi {
    /**
     * 删除推送消息
     * @param delMessageEntity
     * @return
     */
    JdekDelMessageResp delMessage(JdekDelMessageEntity delMessageEntity);
    /**
     * 查询用户余额
     * @param jdekGetBalanceEntity
     * @return
     */
    JdekBalanceVo getBalance(JdekGetBalanceEntity jdekGetBalanceEntity);
    /**
     * 获取消息推送
     * @param jdekGetMessageEntity
     * @return
     */
    JdekGetMessageResp getMessage(JdekGetMessageEntity jdekGetMessageEntity);
    /**
     * 京东E卡下单接口
     * @param jdekOrderEntity
     * @return
     */
    JdekOrderVo placeOrder(JdekOrderEntity jdekOrderEntity);
    /**
     * 重新发起支付
     * @param jdekRepayEntity
     * @return
     */
    JdekRepayResp Repay(JdekRepayEntity jdekRepayEntity);
    /**
     * 反查京东订单信息接口
     * @param jdekSerchByThirdOrderEntity
     * @return
     */
    JdekSerchByThirdOrderVo selectByThirdOrder(JdekSerchByThirdOrderEntity jdekSerchByThirdOrderEntity);
    /**
     * 查询京东E卡信息接口
     * @param jdekSerchOrderEntity
     * @return
     */
    ArrayList<JdekInfoVo> getJdekOrderInfo(JdekSerchOrderEntity jdekSerchOrderEntity);
    /**
     * 京东E卡短信补发接口
     * @param jdekSmsReissueEntity
     * @return
     */
    JdekSmsReissueVo sendMessageAgin(JdekSmsReissueEntity jdekSmsReissueEntity);
}
